package com.ejianc.business.othprice.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
/**
 * 评标记录表
 * 
 * @author generator
 * 
 */
public class BidEvaluationRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目id
    private String firstBidCandidate; // 第一候选人
    private String secondCandidate; // 第二候选人
    private String projectName; // 项目名称
    private String major; // 专业
    private BigDecimal bidPrice; // 拦标价
    private BigDecimal guidePrice; // 指导价
    private Long orgId; // 组织id
    private String billCode;//单据编码

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    private Integer billState;//单据编码


    public String getBillCode() {
        return billCode;
    }
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
    private List<BidCompanyQuotationVO> bidCompanyQuotationList = new ArrayList<>(); // 评标记录表子表
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getFirstBidCandidate() {
        return firstBidCandidate;
    }

    public void setFirstBidCandidate(String firstBidCandidate) {
        this.firstBidCandidate = firstBidCandidate;
    }
    public String getSecondCandidate() {
        return secondCandidate;
    }

    public void setSecondCandidate(String secondCandidate) {
        this.secondCandidate = secondCandidate;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public BigDecimal getBidPrice() {
        return bidPrice;
    }

    public void setBidPrice(BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
    }
    public BigDecimal getGuidePrice() {
        return guidePrice;
    }

    public void setGuidePrice(BigDecimal guidePrice) {
        this.guidePrice = guidePrice;
    }
    
     public List<BidCompanyQuotationVO> getBidCompanyQuotationList() {
        return bidCompanyQuotationList;
     }

     public void setBidCompanyQuotationList(List<BidCompanyQuotationVO> bidCompanyQuotationList) {
        this.bidCompanyQuotationList = bidCompanyQuotationList;
     }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
