package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.outcontract.bean.ListFileEntity;
import com.ejianc.foundation.outcontract.service.IListFileService;
import com.ejianc.foundation.outcontract.vo.ListFileVO;

/**
 * 清单档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("listFile")
public class ListFileController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IListFileService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ListFileVO> saveOrUpdate(@RequestBody ListFileVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ListFileEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            List<Long> ids = new ArrayList<>();
            ids.add(saveorUpdateVO.getId());
           /* Boolean flag = subjectProjectService.delRefCheck(ids);
            if (flag) {
                throw new BusinessException("存在被引用的核算对象，暂不允许编辑");
            }*/
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<ListFileEntity> lambda = Wrappers.<ListFileEntity>lambdaQuery();
            lambda.eq(ListFileEntity::getListCode, saveorUpdateVO.getListCode());
            lambda.eq(ListFileEntity::getTenantId, tenantId);
            lambda.ne(ListFileEntity::getId, saveorUpdateVO.getId());
            List<ListFileEntity> entities = service.list(lambda);
           /* if(!saveorUpdateVO.getListName().contains("装饰"))
            }*/
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
            //校验编码长度是否规范
            Integer listCodeLength = saveorUpdateVO.getListCode().length();
            if(listCodeLength==1 || listCodeLength==3 || listCodeLength==5){
                throw new BusinessException("编码规范错误，不允许保存!");
            }
            saveorUpdateVO.setInnerCode(saveorUpdateVO.getListCode());
            if("01".equals(saveorUpdateVO.getListCode())&&saveorUpdateVO.getListName().contains("装饰")){
                saveorUpdateVO.setInnerCode("a1");
            }
            //判断是否是装饰工程的子节点编码
            if(saveorUpdateVO.getListCode().length()>=4){
                //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                String code = saveorUpdateVO.getListCode().substring(0,4);
                if("0111".equals(code)||"0112".equals(code)||"0113".equals(code)||"0114".equals(code)||"0115".equals(code)){
                    //若是的话，将内码改为a1xx
                    saveorUpdateVO.setInnerCode(("a1"+saveorUpdateVO.getListCode().substring(2,saveorUpdateVO.getListCode().length())));
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, ListFileEntity.class);
            service.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<ListFileEntity> lambda = Wrappers.<ListFileEntity>lambdaQuery();
            lambda.eq(ListFileEntity::getTenantId, tenantId);
            lambda.eq(ListFileEntity::getListCode, saveorUpdateVO.getListCode());
            List<ListFileEntity> entities = service.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
            //校验编码长度是否规范
            Integer listCodeLength = saveorUpdateVO.getListCode().length();
            if(listCodeLength==1 || listCodeLength==3 || listCodeLength==5){
                throw new BusinessException("编码规范错误，不允许保存!");
            }
                Map<String,ListFileVO> map = new HashMap<>();
                saveorUpdateVO.setInnerCode(saveorUpdateVO.getListCode());
                // 内码---为了单独区分装饰工程和建筑工程在咱们系统的表标识，装饰工程一律用a1代替
                if("01".equals(saveorUpdateVO.getListCode())&&saveorUpdateVO.getListName().contains("装饰")){
                    saveorUpdateVO.setInnerCode("a1");
                }
                //判断是否是装饰工程的子节点编码
                if(saveorUpdateVO.getListCode().length()>=4){
                    //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                    String code = saveorUpdateVO.getListCode().substring(0,4);
                    if("0111".equals(code)||"0112".equals(code)||"0113".equals(code)||"0114".equals(code)||"0115".equals(code)){
                        //若是的话，将内码改为a1xx
                        saveorUpdateVO.setInnerCode(("a1"+saveorUpdateVO.getListCode().substring(2,saveorUpdateVO.getListCode().length())));
                    }
                }
                map.put(saveorUpdateVO.getInnerCode(), saveorUpdateVO);
                //设置父级id
                String innercode = saveorUpdateVO.getInnerCode();
                if(innercode.length()==2){
                    //最上级
                }else if(innercode.length()==4){
                    String pcode = innercode.substring(0, 2);
                    //有父节点
                    Long pid = this.setPid(pcode, map);
                    saveorUpdateVO.setParentId(getId(pcode));
                }else if(innercode.length()==6){
                    String pcode = innercode.substring(0, 4);
                    //有父节点
                    Long pid = this.setPid(pcode, map);
                    saveorUpdateVO.setParentId(getId(pcode));
                }else if(innercode.length()>6){
                    String pcode = innercode.substring(0, 6);
                    //有父节点
                    Long pid = this.setPid(pcode, map);
                    saveorUpdateVO.setParentId(getId(pcode));
                }
            entity = BeanMapper.map(saveorUpdateVO, ListFileEntity.class);
            entity.setId(IdWorker.getId());
            service.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    /**
     * @Description saveOrUpdate 修改状态
     */
    @RequestMapping(value = "/updateEn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ListFileVO> updateEn(@RequestBody ListFileVO saveorUpdateVO) {
        return service.updateEn(saveorUpdateVO);
    }

    //根据innerCode查询父级id
    private Long getId(String pcode){
        LambdaQueryWrapper<ListFileEntity> lam = Wrappers.<ListFileEntity>lambdaQuery();
        lam.eq(ListFileEntity::getInnerCode,pcode);
        List<ListFileEntity> listFile = service.list(lam);
        if( CollectionUtils.isNotEmpty(listFile) ){
            return listFile.get(0).getId();
        }else{
            throw new BusinessException("编码规范错误未找到父级，请检查编码!");
        }
    }

    //清单编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode,Map<String,ListFileVO> map){
        if(map.get(pcode)!=null){
            return map.get(pcode).getId();
        }else{
            //父级没有找到，则继续往上找
            if(pcode.length()==2){
                //最上级
                return null;
            }else if(pcode.length()==4){
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            }else if(pcode.length()==6){
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            }else if(pcode.length()>6){
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            }else{
                return null;
            }
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ListFileVO> queryDetail(Long id) {
    	ListFileEntity entity = service.selectById(id);
    	ListFileVO vo = BeanMapper.map(entity, ListFileVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ListFileVO> vos) {
        service.removeByIds(vos.stream().map(ListFileVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("listName");
        fuzzyFields.add("listCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("listCode", "asc");
        List<ListFileEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("listCode");
        fuzzyFields.add("listName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
      //  param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ListFileEntity> list = service.queryList(param);
        List<ListFileVO> vos = new ArrayList<>();
        for(ListFileEntity entity : list){
            ListFileVO vo = BeanMapper.map(entity, ListFileVO.class);
            //变更状态 0未变更 1 已变更
            if(vo.getState()!=null){
                if(vo.getState()==0){
                    vo.setStateName("已停用");
                }
                if(vo.getState()==1){
                    vo.setStateName("已启用");
                }
            }
            vos.add(vo);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("listFileExcelExport.xlsx", beans, response);
    }

    /**
     * 导出的模板 的下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "listFileExcelImport.xlsx", "清单档案导入模板");
    }

    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ListFileVO> importVOS) {
        return CommonResponse.success((String) service.saveImportExcel(request, importVOS));
    }
    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refListFileData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ListFileVO>> refListFileData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ListFileEntity> page = service.queryPage(param,false);
        IPage<ListFileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ListFileVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
