package com.ejianc.foundation.report.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryService;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryReportVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供方合同签约统计汇总表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outcontractSignSummary")
public class OutcontractSignSummaryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutcontractSignSummaryService service;

    /**
     * @Description saveOrUpdate 手动保存当前的数据到es
     */
    @RequestMapping(value = "/saveESData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveESData() {
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        return service.saveESData("供方合同签约统计汇总表（手动）"+curDate);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutcontractSignSummaryReportVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<OutcontractSignSummaryReportVO> pageData = service.queryPage(param);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        List<OutcontractSignSummaryReportVO> list = service.queryPage(param).getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OutcontractSummaryReport-export.xlsx", beans, response);
    }

}
