package com.ejianc.business.notice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.notice.vo.NoticeDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 招标公告
 * 
 * @author generator
 * 
 */
public class NoticeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 招标单号
    private String noticeName; // 招标名称
    private String orgName; // 招标单位
    private Integer noticeType; // 招标类型0-物资招标，1-其他
    private Integer tenderType; // 招标方式0-公开招标，1-邀请招标,2-询价招标
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopTime; // 报价截至时间
    private String pushName; // 招标联系人
    private String pushPhone; // 招标联系电话
    private BigDecimal mny; // 预估总价
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    private java.lang.String noticeContent; // 公告内容
    private List<NoticeDetailVO> noticeDetailList = new ArrayList<>(); // 招标公告明细

    public String getNoticeContent() {
        return noticeContent;
    }

    public void setNoticeContent(String noticeContent) {
        this.noticeContent = noticeContent;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getNoticeName() {
        return noticeName;
    }

    public void setNoticeName(String noticeName) {
        this.noticeName = noticeName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(Integer noticeType) {
        this.noticeType = noticeType;
    }
    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    public Date getStopTime() {
        return stopTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }
    public String getPushName() {
        return pushName;
    }

    public void setPushName(String pushName) {
        this.pushName = pushName;
    }
    public String getPushPhone() {
        return pushPhone;
    }

    public void setPushPhone(String pushPhone) {
        this.pushPhone = pushPhone;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<NoticeDetailVO> getNoticeDetailList() {
        return noticeDetailList;
     }

     public void setNoticeDetailList(List<NoticeDetailVO> noticeDetailList) {
        this.noticeDetailList = noticeDetailList;
     }
}
