package com.ejianc.business.panhuo.api;

import com.ejianc.business.panhuo.hystrix.PanhuoApiHystrix;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = "ejc-panhuo-web", url = "${common.env.feign-client-url}", path = "ejc-panhuo-web", fallback = PanhuoApiHystrix.class)
public interface IPanhuoApi {

    /**
     * 通过材料id查询资产集市对应数量
     * @param materialIds
     * @return
     */
    @RequestMapping(value = "/api/panhuo/queryGoodsByMaterialIds", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<GoodsVO>> queryGoodsByMaterialIds(@RequestParam(value = "materialIds") List<Long> materialIds);

}
