package com.ejianc.business.prjfinance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 其它费用
 * 
 * @author generator
 * 
 */
public class PrjOtherCostVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     *  扣除
     */
    public static final String BILL_TYPE_DEDUCTION = "0";
    /**
     * 保证金类型：退保证金
     */
    public static final String BILL_TYPE_REFUND = "1";
    private String code; // 单据编号
    private String name; // 单据名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String applyTheme; // 申请主题
    private java.math.BigDecimal applyMn; //
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date handleDate; // 办理日期
    private Long handleUserId; //经办人id
    private String handleUserName;//经办人名称
    private java.math.BigDecimal cumDeductionMn; // 累计扣除金额
    private String memo; // 备注
    private String billTypes;
    private String billStateName;


    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 申请主题
     */
    public String getApplyTheme() {
        return applyTheme;
    }

    /**
     * 申请主题
     */
    public void setApplyTheme(String applyTheme) {
        this.applyTheme = applyTheme;
    }
    /**
     * 
     */
    public java.math.BigDecimal getApplyMn() {
        return applyMn;
    }

    /**
     * 
     */
    public void setApplyMn(java.math.BigDecimal applyMn) {
        this.applyMn = applyMn;
    }
    /**
     * 办理日期
     */
    public java.util.Date getHandleDate() {
        return handleDate;
    }

    /**
     * 办理日期
     */
    public void setHandleDate(java.util.Date handleDate) {
        this.handleDate = handleDate;
    }
    /**
     * 
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getHandleUserId() {
        return handleUserId;
    }

    /**
     * 
     */
    @ReferDeserialTransfer
    public void setHandleUserId(Long handleUserId) {
        this.handleUserId = handleUserId;
    }
    /**
     * 累计扣除金额
     */
    public java.math.BigDecimal getCumDeductionMn() {
        return cumDeductionMn;
    }

    /**
     * 累计扣除金额
     */
    public void setCumDeductionMn(java.math.BigDecimal cumDeductionMn) {
        this.cumDeductionMn = cumDeductionMn;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillTypes() {
        return billTypes;
    }

    public void setBillTypes(String billTypes) {
        this.billTypes = billTypes;
    }

    public String getHandleUserName() {
        return handleUserName;
    }

    public void setHandleUserName(String handleUserName) {
        this.handleUserName = handleUserName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
