package com.ejianc.business.prjfinance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 项目目标责任书记录
 * </p>
 *
 * @author liyj
 * @since 2021-07-19
 */
public class ProjectDutyLetterRecordVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 项目部id
     */
    private Long projectDepartmentId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目部名称（冗余）
     */
    private String projectDepartmentName;

    /**
     * 责任书名称
     */
    private String dutyLetterName;

    /**
     * 单据编码
     */
    private String billCode;

    /**
     * 责任书状态(1:未签订,2:履约中,3:已封账)
     */
    private String dutyLetterState;

    /**
     * 经济责任人
     */
    private Long economicPersonId;

    /**
     * 经济责任人
     */
    private String economicPersonName;

	/**
	 * 签约日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date signingDate;
	
    /**
     * 管理费比例
     */
    private BigDecimal managementExpense;
	
    /**
     * 争议违约处理方式
     */
    private Long disputeBreachContractDealway;

    /**
     * 施工合同金额
     */
    private BigDecimal constructionContractAmount;

    /**
     * 风险保证金收取方式: onetime:一次性收取固定金额,bymonth:按月收取金额,bybeceived按已收工程款比例
     */
    private String riskMarginCollectionMethod;

    /**
     * 单次扣除比例
     */
    private BigDecimal singleDeductionRatio;

    /**
     * 风险保证金额
     */
    private BigDecimal riskGuaranteeAmount;

	/**
	 * 计划开工日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date plannedCommencementDate;

	/**
	 * 计划竣工日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date plannedFinishDate;

    /**
     * 合同工期
     */
    private Integer contractDuration;

    /**
     * 经办人
     */
    private Long operator;

    /**
     * 施工合同质量目标
     */
    private String constructionContractQualityTarget;

    /**
     * 安全文明施工标化目标
     */
    private String safeCivilizedConstructionStandardTarget;

    /**
     * 质量环境安全管理要求
     */
    private String qualitySafetyManagementRequirement;

    /**
     * 科技创新目标
     */
    private String technologicalInnovationTarget;

    /**
     * 奖励与处罚
     */
    private String rewardAndPunishment;

    /**
     * 财务管理说明
     */
    private String financialManagementDescription;

    /**
     * 备注
     */
    private String remarks;

	/**
	 * 变更单据原先的id
	 */
	private Long billId;

	/**
	 * 历史版本号
	 */
	private String code;

	/**
	 * 变更原因
	 */
	private String changeReanson;

	/**
	 * 变更人
	 */
	private String changeUserName;

	/**
	 * 变更时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date changeTime;

    /**
     * 子表
     */
    @SubEntity(serviceName = "projectDutyLetterRecordCostlistService", pidName="dutyLetterId")
    private List<ProjectDutyLetterRecordCostlistVO> projectDutyLetterRecordCostList = new ArrayList<>();

    /**
     * 子表
     */
    @SubEntity(serviceName = "projectDutyLetterRecordClauseService", pidName="dutyLetterId")
    private List<ProjectDutyLetterRecordClauseVO> projectDutyLetterRecordClauseList = new ArrayList<>();

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getDutyLetterName() {
		return dutyLetterName;
	}

	public void setDutyLetterName(String dutyLetterName) {
		this.dutyLetterName = dutyLetterName;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public Long getEconomicPersonId() {
		return economicPersonId;
	}

	public void setEconomicPersonId(Long economicPersonId) {
		this.economicPersonId = economicPersonId;
	}

	public String getEconomicPersonName() {
		return economicPersonName;
	}

	public void setEconomicPersonName(String economicPersonName) {
		this.economicPersonName = economicPersonName;
	}

	public Date getSigningDate() {
		return signingDate;
	}

	public void setSigningDate(Date signingDate) {
		this.signingDate = signingDate;
	}

	public Long getDisputeBreachContractDealway() {
		return disputeBreachContractDealway;
	}

	public void setDisputeBreachContractDealway(Long disputeBreachContractDealway) {
		this.disputeBreachContractDealway = disputeBreachContractDealway;
	}

	public String getRiskMarginCollectionMethod() {
		return riskMarginCollectionMethod;
	}

	public void setRiskMarginCollectionMethod(String riskMarginCollectionMethod) {
		this.riskMarginCollectionMethod = riskMarginCollectionMethod;
	}

	public BigDecimal getSingleDeductionRatio() {
		return singleDeductionRatio;
	}

	public void setSingleDeductionRatio(BigDecimal singleDeductionRatio) {
		this.singleDeductionRatio = singleDeductionRatio;
	}

	public BigDecimal getRiskGuaranteeAmount() {
		return riskGuaranteeAmount;
	}

	public void setRiskGuaranteeAmount(BigDecimal riskGuaranteeAmount) {
		this.riskGuaranteeAmount = riskGuaranteeAmount;
	}

	public Date getPlannedCommencementDate() {
		return plannedCommencementDate;
	}

	public void setPlannedCommencementDate(Date plannedCommencementDate) {
		this.plannedCommencementDate = plannedCommencementDate;
	}

	public Date getPlannedFinishDate() {
		return plannedFinishDate;
	}

	public void setPlannedFinishDate(Date plannedFinishDate) {
		this.plannedFinishDate = plannedFinishDate;
	}

	public Integer getContractDuration() {
		return contractDuration;
	}

	public void setContractDuration(Integer contractDuration) {
		this.contractDuration = contractDuration;
	}

	public Long getOperator() {
		return operator;
	}

	public void setOperator(Long operator) {
		this.operator = operator;
	}

	public String getConstructionContractQualityTarget() {
		return constructionContractQualityTarget;
	}

	public void setConstructionContractQualityTarget(String constructionContractQualityTarget) {
		this.constructionContractQualityTarget = constructionContractQualityTarget;
	}

	public String getSafeCivilizedConstructionStandardTarget() {
		return safeCivilizedConstructionStandardTarget;
	}

	public void setSafeCivilizedConstructionStandardTarget(String safeCivilizedConstructionStandardTarget) {
		this.safeCivilizedConstructionStandardTarget = safeCivilizedConstructionStandardTarget;
	}

	public String getQualitySafetyManagementRequirement() {
		return qualitySafetyManagementRequirement;
	}

	public void setQualitySafetyManagementRequirement(String qualitySafetyManagementRequirement) {
		this.qualitySafetyManagementRequirement = qualitySafetyManagementRequirement;
	}

	public String getTechnologicalInnovationTarget() {
		return technologicalInnovationTarget;
	}

	public void setTechnologicalInnovationTarget(String technologicalInnovationTarget) {
		this.technologicalInnovationTarget = technologicalInnovationTarget;
	}

	public String getRewardAndPunishment() {
		return rewardAndPunishment;
	}

	public void setRewardAndPunishment(String rewardAndPunishment) {
		this.rewardAndPunishment = rewardAndPunishment;
	}

	public String getFinancialManagementDescription() {
		return financialManagementDescription;
	}

	public void setFinancialManagementDescription(String financialManagementDescription) {
		this.financialManagementDescription = financialManagementDescription;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public List<ProjectDutyLetterRecordCostlistVO> getProjectDutyLetterRecordCostList() {
		return projectDutyLetterRecordCostList;
	}

	public void setProjectDutyLetterRecordCostList(List<ProjectDutyLetterRecordCostlistVO> projectDutyLetterRecordCostList) {
		this.projectDutyLetterRecordCostList = projectDutyLetterRecordCostList;
	}

	public List<ProjectDutyLetterRecordClauseVO> getProjectDutyLetterRecordClauseList() {
		return projectDutyLetterRecordClauseList;
	}

	public void setProjectDutyLetterRecordClauseList(List<ProjectDutyLetterRecordClauseVO> projectDutyLetterRecordClauseList) {
		this.projectDutyLetterRecordClauseList = projectDutyLetterRecordClauseList;
	}

	public BigDecimal getConstructionContractAmount() {
		return constructionContractAmount;
	}

	public void setConstructionContractAmount(BigDecimal constructionContractAmount) {
		this.constructionContractAmount = constructionContractAmount;
	}

	public BigDecimal getManagementExpense() {
		return managementExpense;
	}

	public void setManagementExpense(BigDecimal managementExpense) {
		this.managementExpense = managementExpense;
	}

	public String getDutyLetterState() {
		return dutyLetterState;
	}

	public void setDutyLetterState(String dutyLetterState) {
		this.dutyLetterState = dutyLetterState;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getChangeReanson() {
		return changeReanson;
	}

	public void setChangeReanson(String changeReanson) {
		this.changeReanson = changeReanson;
	}

	public String getChangeUserName() {
		return changeUserName;
	}

	public void setChangeUserName(String changeUserName) {
		this.changeUserName = changeUserName;
	}

	public Date getChangeTime() {
		return changeTime;
	}

	public void setChangeTime(Date changeTime) {
		this.changeTime = changeTime;
	}

	public Long getBillId() {
		return billId;
	}

	public void setBillId(Long billId) {
		this.billId = billId;
	}

	public String getProjectDepartmentName() {
		return projectDepartmentName;
	}

	public void setProjectDepartmentName(String projectDepartmentName) {
		this.projectDepartmentName = projectDepartmentName;
	}
}
