package com.ejianc.business.prjfinance.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 借款利息结算子表
 * 
 * @author generator
 * 
 */
public class PrjLoanInterestSubVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long loanId; // 单据id
    private String code; // 单据编号
    private String name; // 单据名称
    private java.math.BigDecimal loanMoney; // 借款金额
    private java.math.BigDecimal loanBalance; // 借款结余
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startInterestDate; // 计息开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")

    private java.util.Date upBalanceDate; // 上次结算日期
    private java.math.BigDecimal yearInterest; // 年利率
    private java.math.BigDecimal principalInterest; // 本期利息
    private String memo; // 备注
    private Long pid; // 借款利息id
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中


    public Long getLoanId() {
        return loanId;
    }

    public void setLoanId(Long loanId) {
        this.loanId = loanId;
    }

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 借款金额
     */
    public java.math.BigDecimal getLoanMoney() {
        return loanMoney;
    }

    /**
     * 借款金额
     */
    public void setLoanMoney(java.math.BigDecimal loanMoney) {
        this.loanMoney = loanMoney;
    }
    /**
     * 借款结余
     */
    public java.math.BigDecimal getLoanBalance() {
        return loanBalance;
    }

    /**
     * 借款结余
     */
    public void setLoanBalance(java.math.BigDecimal loanBalance) {
        this.loanBalance = loanBalance;
    }
    /**
     * 计息开始日期
     */
    public java.util.Date getStartInterestDate() {
        return startInterestDate;
    }

    /**
     * 计息开始日期
     */
    public void setStartInterestDate(java.util.Date startInterestDate) {
        this.startInterestDate = startInterestDate;
    }
    /**
     * 上次结算日期
     */
    public java.util.Date getUpBalanceDate() {
        return upBalanceDate;
    }

    /**
     * 上次结算日期
     */
    public void setUpBalanceDate(java.util.Date upBalanceDate) {
        this.upBalanceDate = upBalanceDate;
    }
    /**
     * 年利率
     */
    public java.math.BigDecimal getYearInterest() {
        return yearInterest;
    }

    /**
     * 年利率
     */
    public void setYearInterest(java.math.BigDecimal yearInterest) {
        this.yearInterest = yearInterest;
    }
    /**
     * 本期利息
     */
    public java.math.BigDecimal getPrincipalInterest() {
        return principalInterest;
    }

    /**
     * 本期利息
     */
    public void setPrincipalInterest(java.math.BigDecimal principalInterest) {
        this.principalInterest = principalInterest;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
