package com.ejianc.business.prjfinance.api;

import com.ejianc.business.prjfinance.hystrix.ProjectDutyLetterHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/29 13:44
 */
@FeignClient(name = "ejc-prjfinance-web", url = "${common.env.feign-client-url}", path="ejc-prjfinance-web", fallback = ProjectDutyLetterHystrix.class)
public interface IProjectDutyLetterApi {

    /**
     * 根据项目Id查询对应的费用清单结余
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/projectDutyLetter/getCostMoneyByProjectId")
    public CommonResponse<BigDecimal> getCostMoneyByProjectId(@RequestParam Long projectId);

}
