package com.ejianc.business.prjfinance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目代转款
 *
 * @author CJ
 * @Description:
 * @date 2021/7/21 19:10
 */
public class PrjAdvancePaymentVO extends BaseVO {
    private static final long serialVersionUID = 8483717542144840081L;

    /**
     * 项目待转款单据类型：收款登记
     */
    public static final String BILL_TYPE_ADVANCE_PAYMENT = "1";
    /**
     * 项目待转款单据类型：退款申请
     */
    public static final String BILL_TYPE_BACK_PAYMENT = "2";

    /**
     * 单据编码
     */
    private String billCode;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 所属项目名称
     */
    private String projectName;

    /**
     * 所属项目Id
     */
    private Long projectId;

    /**
     * 单据类型：1-收款登记，2-退款申请
     */
    private String billType;

    /**
     * 主题
     */
    private String subject;
    /**
     * 商机登记Id
     */
    private Long opporId;

    /**
     * 商机登记名称
     */
    private String opporName;
    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 办理日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date handlingDate;

    /**
     * 收/付款方式
     */
    private Long transactionMode;

    /**
     * 经办人名称
     */
    private String operatorName;

    /**
     * 经办人Id
     */
    private Long operatorId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 累计待转款金额
     */
    private BigDecimal totalAdvancePayAmt;

    /**
     * 累计退款金额
     */
    private BigDecimal totalBackAmt;

    /**
     * 剩余待转款
     */
    private BigDecimal remanentAdvancePayAmt;

    /**
     * 剩余可退金额
     */
    private BigDecimal remremainingRefundableAmt;

    /**
     * 所属组织Id
     */
    private Long orgId;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 单据状态名称
     */
    private String billStateName;


//    退款申请使用字段
    /**
     * 退款账号账户名
     */
    private String recBankAccName;
    /**
     * 退款账号银行账号
     */
    private String recBankAcc;
    /**
     * 退款账号开户行
     */
    private String recOpenAccBankName;

    /**
     * 收/付款方式
     */
    private String transactionModeName;

    public String getRecBankAccName() {
        return recBankAccName;
    }

    public void setRecBankAccName(String recBankAccName) {
        this.recBankAccName = recBankAccName;
    }

    public String getRecBankAcc() {
        return recBankAcc;
    }

    public void setRecBankAcc(String recBankAcc) {
        this.recBankAcc = recBankAcc;
    }

    public String getRecOpenAccBankName() {
        return recOpenAccBankName;
    }

    public void setRecOpenAccBankName(String recOpenAccBankName) {
        this.recOpenAccBankName = recOpenAccBankName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getRemremainingRefundableAmt() {
        return remremainingRefundableAmt;
    }

    public void setRemremainingRefundableAmt(BigDecimal remremainingRefundableAmt) {
        this.remremainingRefundableAmt = remremainingRefundableAmt;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Date getHandlingDate() {
        return handlingDate;
    }
    @ReferSerialTransfer(referCode="business-opportunity-register")
    public Long getOpporId() {
        return opporId;
    }
    @ReferDeserialTransfer
    public void setOpporId(Long opporId) {
        this.opporId = opporId;
    }

    public String getOpporName() {
        return opporName;
    }

    public void setOpporName(String opporName) {
        this.opporName = opporName;
    }

    public void setHandlingDate(Date handlingDate) {
        this.handlingDate = handlingDate;
    }

    public Long getTransactionMode() {
        return transactionMode;
    }

    @ReferDeserialTransfer
    public void setTransactionMode(Long transactionMode) {
        this.transactionMode = transactionMode;
    }

    public String getTransactionModeName() {
        return transactionModeName;
    }

    public void setTransactionModeName(String transactionModeName) {
        this.transactionModeName = transactionModeName;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    @ReferDeserialTransfer
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getTotalAdvancePayAmt() {
        return totalAdvancePayAmt;
    }

    public void setTotalAdvancePayAmt(BigDecimal totalAdvancePayAmt) {
        this.totalAdvancePayAmt = totalAdvancePayAmt;
    }

    public BigDecimal getTotalBackAmt() {
        return totalBackAmt;
    }

    public void setTotalBackAmt(BigDecimal totalBackAmt) {
        this.totalBackAmt = totalBackAmt;
    }

    public BigDecimal getRemanentAdvancePayAmt() {
        return remanentAdvancePayAmt;
    }

    public void setRemanentAdvancePayAmt(BigDecimal remanentAdvancePayAmt) {
        this.remanentAdvancePayAmt = remanentAdvancePayAmt;
    }

    @ReferDeserialTransfer
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
