package com.ejianc.business.prjfinance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 税务费用
 * 
 * @author generator
 * 
 */
public class TaxCostVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long costId; // 费用类型
    private String costName; // 费用类型名称
    private String backOrDel; // 单据类型
    private BigDecimal amount; // 金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date costTime; // 费用日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String employeeDepartment; // 经办人部门
    private String memo; // 备注
    private String billCode;
    private Integer billState;
    private String billStateName;
    private List<TaxCostInvoiceVO> taxCostInvoiceList = new ArrayList<>(); // 收票明细
    /**
     * 所属组织Id
     */
    private Long orgId;
    private String backOrDelName; // 单据类型名称
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCostId() {
        return costId;
    }
    @ReferDeserialTransfer
    public void setCostId(Long costId) {
        this.costId = costId;
    }
    public String getCostName() {
        return costName;
    }

    public void setCostName(String costName) {
        this.costName = costName;
    }
    public String getBackOrDel() {
        return backOrDel;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public void setBackOrDel(String backOrDel) {
        this.backOrDel = backOrDel;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public Date getCostTime() {
        return costTime;
    }

    public void setCostTime(Date costTime) {
        this.costTime = costTime;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public List<TaxCostInvoiceVO> getTaxCostInvoiceList() {
        return taxCostInvoiceList;
    }

    public void setTaxCostInvoiceList(List<TaxCostInvoiceVO> taxCostInvoiceList) {
        this.taxCostInvoiceList = taxCostInvoiceList;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeDepartment() {
        return employeeDepartment;
    }

    public void setEmployeeDepartment(String employeeDepartment) {
        this.employeeDepartment = employeeDepartment;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public String getBackOrDelName() {
        return backOrDelName;
    }

    public void setBackOrDelName(String backOrDelName) {
        this.backOrDelName = backOrDelName;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
