package com.ejianc.business.prjfinance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 预缴税款单
 * 
 * @author generator
 * 
 */
public class PrepaymentTaxVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private String projectName; // 项目名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date prepaymentTime; // 预缴日期
    private BigDecimal amount; // 本次预缴金额
    private Integer firmFlag; // 是否公司代缴(1:是，2：否)
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String employeeDepartment; // 经办人部门
    private String memo; // 备注
    private String billCode; // 单据编码
    private Integer billState; // 单据状态（审批必须字段）
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String firmFlagName; // 组织名称


    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getPrepaymentTime() {
        return prepaymentTime;
    }

    public void setPrepaymentTime(Date prepaymentTime) {
        this.prepaymentTime = prepaymentTime;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public Integer getFirmFlag() {
        return firmFlag;
    }

    public void setFirmFlag(Integer firmFlag) {
        this.firmFlag = firmFlag;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeDepartment() {
        return employeeDepartment;
    }

    public void setEmployeeDepartment(String employeeDepartment) {
        this.employeeDepartment = employeeDepartment;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getFirmFlagName() {
        return firmFlag==1?"是":"否";
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    
}
