package com.ejianc.business.prjfinance.api;

import com.ejianc.business.prjfinance.hystrix.ProjectDutyLetterHystrix;
import com.ejianc.business.prjfinance.vo.OperationCostVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/29 13:44
 */
@FeignClient(name = "ejc-prjfinance-web", url = "${common.env.feign-client-url}", path="ejc-prjfinance-web", fallback = ProjectDutyLetterHystrix.class)
public interface IProjectDutyLetterApi {

    /**
     * 根据项目Id查询对应的费用清单结余
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/projectDutyLetter/getCostMoneyByProjectId")
    CommonResponse<BigDecimal> getCostMoneyByProjectId(@RequestParam Long projectId);

    /**
     * 根据项目Id查询对应的项目目标责任书
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/projectDutyLetter/getProjectDutyLetterDetail")
    CommonResponse<ProjectDutyLetterVO> getProjectDutyLetterDetail(@RequestParam Long projectId);


    /**
     * 根据项目Id查询对应的联营项目费用列表
     */
    @PostMapping(value = "/api/projectDutyLetter/getOperationList")
    CommonResponse<List<OperationCostVO>> getOperationList(@RequestBody OperationCostVO operationCostVO);

    @GetMapping(value = "/api/projectDutyLetter/getOperationList4Org")
    CommonResponse<List<OperationCostVO>> getOperationList4Org();

}
