package com.ejianc.business.prjfinance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 风险保证金
 *
 * @author CJ
 * @Description:
 * @date 2021/7/19 11:31
 */
public class RiskMarginTransVO extends BaseVO {

    private static final long serialVersionUID = -3993589874628284808L;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 申请主题
     */
    private String applySubject;

    /**
     * 申请金额
     */
    private BigDecimal applyAmt;

    /**
     * 申请日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date applyDate;

    /**
     * 经办人Id
     */
    private Long operatorId;

    /**
     * 经办人名称
     */
    private String operatorName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 所属项目Id
     */
    private Long projectId;


    /**
     * 所属组织Id
     */
    private Long orgId;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 来源单据Id
     */
    private Long sourceId;


    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getApplySubject() {
        return applySubject;
    }

    public void setApplySubject(String applySubject) {
        this.applySubject = applySubject;
    }

    public BigDecimal getApplyAmt() {
        return applyAmt;
    }

    public void setApplyAmt(BigDecimal applyAmt) {
        this.applyAmt = applyAmt;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
