package com.ejianc.business.prjfinance.controller;

import java.math.BigDecimal;
import java.util.List;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterRecordEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterRecordService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterRecordCostlistVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * @Author liyongjia
 * @Date 2021/5/11
 * @Description
 */

@Controller
@RequestMapping("/projectDutyLetterRecord/")
public class ProjectDutyLetterRecordController {
	private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterRecordController.class);

    @Autowired
    IProjectDutyLetterRecordService projectDutyLetterRecordService;
    @Autowired
    IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;

    /**
     * @Author liyongjia
     * @Date 2021/5/11 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return 
     */
    @RequestMapping(value = "queryList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(Long id, HttpServletRequest request) {
        QueryParam param = new QueryParam();
        param.getParams().put("billId",new Parameter(QueryParam.EQ,id));
        param.getOrderMap().put("createTime", "desc");
        List<ProjectDutyLetterRecordEntity> list = projectDutyLetterRecordService.queryList(param, false);
        ProjectDutyLetterEntity entity = projectDutyLetterService.getById(id);
        JSONObject result = new JSONObject();
        result.put("id", id);
        result.put("changeRecords", list);
        result.put("isChanging", !"1".equals(entity.getChangeState()));
        return CommonResponse.success("查询详情数据成功！",result);
    }

    
    /**
     * @Author liyongjia
     * @Date 2021/5/11 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return 
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectDutyLetterRecordVO> queryDetail(Long id, HttpServletRequest request) {
        ProjectDutyLetterRecordEntity entity = projectDutyLetterRecordService.selectById(id);
        ProjectDutyLetterRecordVO vo = BeanMapper.map(entity, ProjectDutyLetterRecordVO.class);
        CommonResponse<JSONObject> inAndOut = iProjectBoardApi.queryIncoemAndExpendByProjectId(vo.getProjectId());
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(vo.getProjectDutyLetterRecordCostList()!=null&&vo.getProjectDutyLetterRecordCostList().size()>0){
        		List<ProjectDutyLetterRecordCostlistVO> list = vo.getProjectDutyLetterRecordCostList();
        		BigDecimal otherMoney = new BigDecimal(0);
        		for(ProjectDutyLetterRecordCostlistVO cost : list){
    				if(cost.getFormula()!=null){
    					String evalq = cost.getFormula();
    					for (String key : dataresultIncoemAndExpend.keySet()) {
    						String value = "0";
                            value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                            evalq = evalq.replaceAll(key, value);
                        }
    					
    					ScriptEngineManager manager = new ScriptEngineManager();
    					ScriptEngine se = manager.getEngineByName("js");
    					BigDecimal money = new BigDecimal(0);
						try {
							money = new BigDecimal( (Double) se.eval(evalq));
						} catch (ScriptException e) {
							e.printStackTrace();
						}
    					if("delete".equals(cost.getAddOrDelete())){
    						money = new BigDecimal(0).subtract(money);
    					}
						cost.setAmount(money);
						otherMoney = otherMoney.add(money);
    				}else{
						cost.setAmount(new BigDecimal(0));
    				}
        		}
        	}
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
}
