package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.RiskMarginEntity;
import com.ejianc.business.prjfinance.mapper.RiskMarginMapper;
import com.ejianc.business.prjfinance.service.IRiskMarginService;
import com.ejianc.business.prjfinance.vo.RiskMarginVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/19 11:33
 */
@Service(value = "riskMarginService")
public class RiskMarginServiceImpl extends BaseServiceImpl<RiskMarginMapper, RiskMarginEntity> implements IRiskMarginService {

    @Override
    public Map<String, BigDecimal> getProjectCashDepositInfo(Long projectId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<RiskMarginEntity> query = new QueryWrapper<>();
        query.select(" sum(if(bill_type = 1, apply_amt, 0)) as totalDeductCashDeposit, sum(if(bill_type = 2, apply_amt, 0)) as totalBackCashDeposit");
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.and(q -> q.or(qe -> qe.eq("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode())).or(qe -> qe.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode())));
        Map<String, Object> data = super.getMap(query);
        if(null != data) {
            resp.put("totalDeductCashDeposit", null != data.get("totalDeductCashDeposit") ? new BigDecimal(data.get("totalDeductCashDeposit").toString()) : BigDecimal.ZERO);
            resp.put("totalBackCashDeposit", null != data.get("totalBackCashDeposit") ? new BigDecimal(data.get("totalBackCashDeposit").toString()) : BigDecimal.ZERO);
            resp.put("spareDepositAmt", resp.get("totalDeductCashDeposit").subtract(resp.get("totalBackCashDeposit")));
        } else {
            resp.put("totalDeductCashDeposit", BigDecimal.ZERO);
            resp.put("totalBackCashDeposit", BigDecimal.ZERO);
            resp.put("spareDepositAmt", BigDecimal.ZERO);
        }

        //查询项目下所有退保证金单据金额
        query = new QueryWrapper<>();
        query.select("sum(apply_amt) as totalBackAmt");
        query.eq("project_id", projectId);
        query.eq("bill_type", RiskMarginVO.BILL_TYPE_BACK_CASH_DEPOSIT);
        query.eq("dr", BaseVO.DR_UNDELETE);
        data = super.getMap(query);
        if(null != data) {
            resp.put("remremainingRefundableAmt", null != data.get("totalBackAmt") ? new BigDecimal(data.get("totalBackAmt").toString()) : BigDecimal.ZERO);
        } else {
            resp.put("remremainingRefundableAmt", BigDecimal.ZERO);
        }
        resp.put("remremainingRefundableAmt", resp.get("totalDeductCashDeposit").subtract(resp.get("remremainingRefundableAmt")));

        return resp;
    }

    @Override
    public Map<String, BigDecimal> sumCashDeposit(QueryParam queryParam) {
        Map<String, BigDecimal> resp = new HashMap<>();
        Map<String, Object> queryResult = null;
        QueryWrapper<RiskMarginEntity> query = changeToQueryWrapper(queryParam);
        query.select(" sum(if(bill_type = 1, apply_amt, 0)) as totalDeductCashDeposit, sum(if(bill_type = 2, apply_amt, 0)) as totalBackCashDeposit");
        queryResult = super.getMap(query);

        if(null != queryResult) {
            resp.put("totalDeductCashDeposit", null != queryResult.get("totalDeductCashDeposit") ? new BigDecimal(queryResult.get("totalDeductCashDeposit").toString()) : BigDecimal.ZERO);
            resp.put("totalBackCashDeposit", null != queryResult.get("totalBackCashDeposit") ? new BigDecimal(queryResult.get("totalBackCashDeposit").toString()) : BigDecimal.ZERO);
        } else {
            resp.put("totalDeductCashDeposit", BigDecimal.ZERO);
            resp.put("totalBackCashDeposit", BigDecimal.ZERO);
        }

        return resp;
    }

    @Override
    public List<RiskMarginVO> freeBillListByPrjId(Long projectId, String billType, Long billId) {
        List<RiskMarginVO> resp = new ArrayList<>();
        QueryWrapper<RiskMarginEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        if(StringUtils.isNotBlank(billType)) {
            query.eq("bill_type", billType);
        }
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        if(null != billId) {
            query.ne("bill_id", billId);
        }

        List<RiskMarginEntity> entityList = super.list(query);
        if(CollectionUtils.isNotEmpty(entityList)) {
            resp = BeanMapper.mapList(entityList, RiskMarginVO.class);
        }

        return resp;
    }

}
