package com.ejianc.business.prjfinance.vo;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 项目目标责任书
 * </p>
 *
 * @author liyj
 * @since 2021-07-19
 */
public class ProjectDutyLetterExportVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 单据状态
     */
    private String billStateName;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 项目id
     */
    private Long projectId;
    
    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 责任书名称
     */
    private String dutyLetterName;

    /**
     * 单据编码
     */
    private String billCode;

    /**
     * 责任书状态(1:未签订,2:履约中,3:已封账)
     */
    private String dutyLetterState;

    /**
     * 经济责任人
     */
    private Long economicPersonId;

    /**
     * 经济责任人
     */
    private String economicPersonName;

	/**
	 * 签约日期
	 */
	private String signingDate;
	
    /**
     * 管理费比例
     */
    private BigDecimal managementExpense;

    /**
     * 施工合同金额
     */
    private BigDecimal constructionContractAmount;

    /**
     * 经办人
     */
    private Long operator;

    /**
     * 经办人
     */
    private String operatorName;

    /**
     * 变更状态（"0":"未签订","1":"履约中","2":"未签订"）
     */
    private String changeState;

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getDutyLetterName() {
		return dutyLetterName;
	}

	public void setDutyLetterName(String dutyLetterName) {
		this.dutyLetterName = dutyLetterName;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getDutyLetterState() {
		return dutyLetterState;
	}

	public void setDutyLetterState(String dutyLetterState) {
		this.dutyLetterState = dutyLetterState;
	}

	public Long getEconomicPersonId() {
		return economicPersonId;
	}

	public void setEconomicPersonId(Long economicPersonId) {
		this.economicPersonId = economicPersonId;
	}

	public String getEconomicPersonName() {
		return economicPersonName;
	}

	public void setEconomicPersonName(String economicPersonName) {
		this.economicPersonName = economicPersonName;
	}

	public String getSigningDate() {
		return signingDate;
	}

	public void setSigningDate(String signingDate) {
		this.signingDate = signingDate;
	}

	public BigDecimal getManagementExpense() {
		return managementExpense;
	}

	public void setManagementExpense(BigDecimal managementExpense) {
		this.managementExpense = managementExpense;
	}

	public BigDecimal getConstructionContractAmount() {
		return constructionContractAmount;
	}

	public void setConstructionContractAmount(BigDecimal constructionContractAmount) {
		this.constructionContractAmount = constructionContractAmount;
	}

	public Long getOperator() {
		return operator;
	}

	public void setOperator(Long operator) {
		this.operator = operator;
	}

	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public String getChangeState() {
		return changeState;
	}

	public void setChangeState(String changeState) {
		this.changeState = changeState;
	}

	public String getCreateTime() {
		return createTime;
	}

	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

}
