package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestSubEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneySubEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestService;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("prjLoanInterest") 
public class PrjLoanInterestBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IPrjLoanInterestService prjLoanInterestService;
	@Autowired
	private IProjectLoanService iProjectLoanService;
	@Autowired
	private IPrjLoanInterestSubService prjLoanInterestSubService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	/*@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};*/

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PrjLoanInterestEntity entity = prjLoanInterestService.selectById(billId);
		if(entity == null){
			return CommonResponse.error("单据不存在！");
		}
		List<PrjLoanInterestSubEntity> subEntities = entity.getLoanInterestSubEntities();
		if(ListUtil.isNotEmpty(subEntities)){
			for (PrjLoanInterestSubEntity subEntity : subEntities) {
				/** 累加到已还利息 */
				iProjectLoanService.updateBillAllInterestMoney(subEntity.getLoanId(),subEntity.getPrincipalInterest(),IProjectLoanService.add);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PrjLoanInterestEntity main = prjLoanInterestService.selectById(billId);
		if(main == null){
			return CommonResponse.error("单据不存在！");
		}
		QueryParam param = new QueryParam();
		param.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));
		param.getParams().put("projectId",new Parameter(QueryParam.EQ,main.getProjectId()));
		param.getOrderMap().put("handleDate",QueryParam.DESC);
		List<PrjLoanInterestEntity> list = prjLoanInterestService.queryList(param);
		if(ListUtil.isNotEmpty(list)){
			/** 不是最新审批通过的不能弃审 */
			if(!billId.equals(list.get(0).getId())){
				CommonResponse.error("该单据不是最新已审核单据，无法弃审！");
			}
		}
		param.getParams().put("billState",new Parameter(QueryParam.IN,"0,2,4,5"));
		list = prjLoanInterestService.queryList(param);
		/** 存在自由态，审核中的不能弃审 */
		if(ListUtil.isNotEmpty(list)){
			CommonResponse.error("存在未审核通过的单据不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PrjLoanInterestEntity main = prjLoanInterestService.selectById(billId);
		if(main == null){
			return CommonResponse.error("单据不存在！");
		}
		List<PrjLoanInterestSubEntity> subEntities = main.getLoanInterestSubEntities();
		if(ListUtil.isNotEmpty(subEntities)){
			for (PrjLoanInterestSubEntity subEntity : subEntities) {
				/** 已还款金额减掉当前金额 */

				iProjectLoanService.updateBillAllInterestMoney(subEntity.getLoanId(),subEntity.getPrincipalInterest(),IProjectLoanService.subtract);
			}
		}
		return CommonResponse.success();
	}

}
