package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.RiskMarginEntity;
import com.ejianc.business.prjfinance.service.IRiskMarginService;
import com.ejianc.business.prjfinance.vo.RiskMarginVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/20 16:22
 */
@Service(value = "riskMargin")
public class RiskMarginBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRiskMarginService riskMarginService;

    /**
     * 弃审
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return beforeBpmBackCheck(billId, state, billTypeCode);
    }

    /**
     * 有审批流的撤回
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return beforeBpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> beforeBpmBackCheck(Long billId, Integer state, String billTypeCode) {
        RiskMarginEntity entity = riskMarginService.selectById(billId);
        if(RiskMarginVO.SOURCE_TYPE_AUTOG_ENERATION.equals(entity.getSourceType())) {
            return CommonResponse.error("操作失败，自动生成的保证金无法执行此操作。");
        }
        if(RiskMarginVO.BILL_TYPE_DEDUCT_CASH_DEPOSIT.equals(entity.getBillType())) {
            //当单据申请金额小于等于剩余可退还金额时，可弃审；
            Map<String, BigDecimal> info = riskMarginService.getProjectCashDepositInfo(entity.getProjectId());
            if(entity.getApplyAmt().compareTo(info.get("remremainingRefundableAmt")) > 0) {
                return CommonResponse.error("操作失败，单据申请金额大于剩余可退还金额。");
            }
        }

        return CommonResponse.success("风险保证金弃审前校验成功！");
    }
}
