package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.PrjAdvancePaymentEntity;
import com.ejianc.business.prjfinance.service.IPrjAdvancePaymentService;
import com.ejianc.business.prjfinance.vo.PrjAdvancePaymentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/21 20:00
 */
@Service(value = "prjAdvancePayment")
public class PrjAdvancePayBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IPrjAdvancePaymentService prjAdvancePaymentService;

    /**
     * 弃审
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return beforeBpmBackCheck(billId, state, billTypeCode);
    }

    /**
     * 有审批流的撤回
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return beforeBpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> beforeBpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PrjAdvancePaymentEntity entity = prjAdvancePaymentService.selectById(billId);
        if(PrjAdvancePaymentVO.BILL_TYPE_ADVANCE_PAYMENT.equals(entity.getBillType())) {
            //当单据申请金额小于等于剩余可退还金额时，可弃审；
            Map<String, BigDecimal> info = prjAdvancePaymentService.getTotalPrjAdvancePayInfo(entity.getProjectId());
            if(entity.getAmount().compareTo(info.get("remremainingRefundableAmt")) > 0) {
                return CommonResponse.error("操作失败，单据申请金额大于剩余可退还金额。");
            }
        }

        return CommonResponse.success("项目代转款弃审前校验成功！");
    }

}
