package com.ejianc.business.prjfinance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 风险保证金
 *
 * @author CJ
 * @Description:
 * @date 2021/7/19 11:29
 */
@TableName(value = "ejc_prjfinance_riskmargin")
public class RiskMarginEntity extends BaseEntity {
    private static final long serialVersionUID = -8222199521362266143L;

    /**
     * 单据编号
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 单据类型：1-扣保证金，2-退保证金
     */
    @TableField(value = "bill_type")
    private String billType;

    /**
     * 单据来源：1-自动生成，2-手动生成
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 所属项目Id
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 申请主题
     */
    @TableField(value = "apply_subject")
    private String applySubject;

    /**
     * 申请金额
     */
    @TableField(value = "apply_amt")
    private BigDecimal applyAmt;

    /**
     * 申请日期
     */
    @TableField(value = "apply_date")
    private Date applyDate;

    /**
     * 经办人Id
     */
    @TableField(value = "operator_id")
    private Long operatorId;

    /**
     * 经办人名称
     */
    @TableField(value = "operator_name")
    private String operatorName;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 所属组织Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 来源单据Id
     */
    @TableField(value = "source_id")
    private Long sourceId;

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getApplySubject() {
        return applySubject;
    }

    public void setApplySubject(String applySubject) {
        this.applySubject = applySubject;
    }

    public BigDecimal getApplyAmt() {
        return applyAmt;
    }

    public void setApplyAmt(BigDecimal applyAmt) {
        this.applyAmt = applyAmt;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
