package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.bean.PrjOtherCostEntity;
import com.ejianc.business.prjfinance.service.IPrjOtherCostService;
import com.ejianc.business.prjfinance.vo.PrjOtherCostVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 其它费用
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("otherCost")
public class PrjOtherCostController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IPrjOtherCostService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;
    private static final String BILL_CODE = "otherPrjfinanceBillType";
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PrjOtherCostVO> saveOrUpdate(@RequestBody PrjOtherCostVO saveorUpdateVO) {
    	PrjOtherCostEntity entity = BeanMapper.map(saveorUpdateVO, PrjOtherCostEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PrjOtherCostVO vo = BeanMapper.map(entity, PrjOtherCostVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrjOtherCostVO> queryDetail(Long id) {
    	PrjOtherCostEntity entity = service.selectById(id);
        PrjOtherCostVO vo = BeanMapper.map(entity, PrjOtherCostVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjOtherCostVO> vos) {
        service.removeByIds(vos.stream().map(PrjOtherCostVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("applyTheme");

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<PrjOtherCostEntity> page = service.queryPage(param,false);
        IPage<PrjOtherCostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrjOtherCostVO.class));
        Map<String,BigDecimal> cumAmount =service.queryCumAmountListAll(param);
        resp.put("total", pageData.getTotal());
        resp.put("current", pageData.getCurrent());
        resp.put("size", pageData.getSize());
        resp.put("pages", pageData.getPages());
        resp.put("records", pageData.getRecords());
        resp.put("deductionAmount", cumAmount.get("deductionAmount"));
        resp.put("refundAmount", cumAmount.get("refundAmount"));

        return CommonResponse.success("查询列表数据成功！",resp);
    }

    /**
     * 合计当前项目下的扣除累计金额和新增退还
     * @param projectId
     * @param billType
     * @return
     */
    @RequestMapping(value = "/queryCumAmount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse< Map<String,BigDecimal>> queryCumAmount(Long projectId,String billType){
        Map<String,BigDecimal> map =service.queryCumAmount(projectId,billType);
        return CommonResponse.success("查询累计金额成功！",map);
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("applyTheme");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);

        IPage<PrjOtherCostEntity> pageData = service.queryPage(queryParam, false);
        List<PrjOtherCostVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(prjOtherCost -> {
                PrjOtherCostVO r = BeanMapper.map(prjOtherCost, PrjOtherCostVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                r.setBillTypes(PrjOtherCostVO.BILL_TYPE_DEDUCTION.equals(r.getBillTypes()) ? "扣除" : "退还");
                voList.add(r);
            });
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("otherCost-export.xlsx", beans, response);
    }

    /**
     * 提供给项目责任书
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryProjectDutyLetterCumAmountAll", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryCumAmount(Long projectId){
        JSONObject jsonObject = new JSONObject();
        Map<String,BigDecimal> map =service.queryProjectCumAllAmount(projectId);
        List<PrjOtherCostEntity> list = service.queryProjectList(projectId);
        jsonObject.put("deductionAmount",map.get("deductionAmount"));
        jsonObject.put("refundAmount",map.get("refundAmount"));
        jsonObject.put("cumDeductionMn",map.get("cumDeductionMn"));
        jsonObject.put("records",list);
        return CommonResponse.success("查询累计金额成功！",jsonObject);
    }
}
