package com.ejianc.business.prjfinance.controller.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * @author liyongjia
 * @Description:
 * @date 2021/7/29 14:01
 */
@RestController
@RequestMapping("/api/projectDutyLetter/")
public class ProjectDutyLetterApi {

    @Autowired
    private IProjectDutyLetterService projectDutyLetterService;

    @Autowired
    private IProjectDutyLetterCostlistService projectDutyLetterCostlistService;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;

    /**
     * 根据项目Id查询对应的
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "getCostMoneyByProjectId")
    public CommonResponse<BigDecimal> getCostMoneyByProjectId(@RequestParam Long projectId) {
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(projectId);
		List<ProjectDutyLetterCostlistEntity> costList = projectDutyLetterCostlistService.getCostListByProjectIds(projectIds);
        //累计扣除
        BigDecimal allDelete = new BigDecimal(0);
        //累计返还
        BigDecimal allAdd = new BigDecimal(0);
        //累计结余
        BigDecimal amount = new BigDecimal(0);
		CommonResponse<JSONObject> inAndOut = iProjectBoardApi.queryIncoemAndExpendByProjectId(projectId);
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(costList!=null&&costList.size()>0){
				for(ProjectDutyLetterCostlistEntity cost : costList){
					if(cost.getFormula()!=null){
						String evalq = cost.getFormula();
						for (String key : dataresultIncoemAndExpend.keySet()) {
							String value = "0";
		                    value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
		                    evalq = evalq.replaceAll(key, value);
		                }
						
						ScriptEngineManager manager = new ScriptEngineManager();
						ScriptEngine se = manager.getEngineByName("js");
						BigDecimal money = new BigDecimal(0);
						try {
							money = new BigDecimal( Double.valueOf(se.eval(evalq).toString()) );
						} catch (Exception e) {
							e.printStackTrace();
						}
    					if("del".equals(cost.getBackOrDel())){
    						allDelete = allDelete.add(money);
    					}else{
    						allAdd = allAdd.add(money);
    					}
						cost.setAmount(money);
					}else{
						cost.setAmount(new BigDecimal(0));
					}
				}
        		//将费用详情金额（冗余-供报表查询）数据进行保存
        		projectDutyLetterCostlistService.saveOrUpdateBatch(costList, costList.size(), false);
        	}
        }
        amount = allDelete.subtract(allAdd);
		return CommonResponse.success(amount);
    }

}
