package com.ejianc.business.prjfinance.service;

import com.ejianc.business.prjfinance.bean.PrjOtherCostEntity;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 其它费用
 * 
 * @author generator
 * 
 */
public interface IPrjOtherCostService extends IBaseService<PrjOtherCostEntity> {
    /**
     * 合计当前项目下的扣除累计金额和新增退还
     * @param projectId
     * @param billType
     * @return
     */
    public Map<String, BigDecimal> queryCumAmount(Long projectId,String billType);

    /**
     * 统计全部金额
     * @param param
     * @return
     */
    public Map<String,BigDecimal> queryCumAmountListAll(QueryParam param);

    /**
     * 查询 累计扣除/累计返还/累计结余（提供给项目责任书）
     * @param projectId
     * @return
     */
    public Map<String,BigDecimal> queryProjectCumAllAmount(Long projectId);

    /**
     * 查询列表（提供给项目责任书）
     * @param projectId
     * @return
     */
    public List<PrjOtherCostEntity> queryProjectList(Long projectId);

}
