package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.PrjAdvancePaymentEntity;
import com.ejianc.business.prjfinance.mapper.PrjAdvancePaymentMapper;
import com.ejianc.business.prjfinance.service.IPrjAdvancePaymentService;
import com.ejianc.business.prjfinance.vo.PrjAdvancePaymentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/21 19:28
 */
@Service(value = "prjAdvancePaymentService")
public class PrjAdvancePaymentServiceImpl extends BaseServiceImpl<PrjAdvancePaymentMapper, PrjAdvancePaymentEntity> implements IPrjAdvancePaymentService {
    @Override
    public Map<String, BigDecimal> sumPrjAdvancePayInfo(QueryParam queryParam) {
        Map<String, BigDecimal> resp = new HashMap<>();
        Map<String, Object> queryResult = null;
        QueryWrapper<PrjAdvancePaymentEntity> query = changeToQueryWrapper(queryParam);
        query.select(" sum(if(bill_type = 1, amount, 0)) as totalAdvancePayAmt, sum(if(bill_type = 2, amount, 0)) as totalBackAmt");
        queryResult = super.getMap(query);

        if(null != queryResult) {
            resp.put("totalAdvancePayAmt", null != queryResult.get("totalAdvancePayAmt") ? new BigDecimal(queryResult.get("totalAdvancePayAmt").toString()) : BigDecimal.ZERO);
            resp.put("totalBackAmt", null != queryResult.get("totalBackAmt") ? new BigDecimal(queryResult.get("totalBackAmt").toString()) : BigDecimal.ZERO);
        } else {
            resp.put("totalAdvancePayAmt", BigDecimal.ZERO);
            resp.put("totalBackAmt", BigDecimal.ZERO);
        }

        return resp;
    }

    @Override
    public Map<String, BigDecimal> getTotalPrjAdvancePayInfo(Long projectId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<PrjAdvancePaymentEntity> query = new QueryWrapper<>();
        query.select(" sum(if(bill_type = 1, amount, 0)) as totalAdvancePayAmt, sum(if(bill_type = 2, amount, 0)) as totalBackAmt");
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.and(q -> q.or(qe -> qe.eq("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode())).or(qe -> qe.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode())));
        Map<String, Object> data = super.getMap(query);
        if(null != data) {
            resp.put("totalAdvancePayAmt", null != data.get("totalAdvancePayAmt") ? new BigDecimal(data.get("totalAdvancePayAmt").toString()) : BigDecimal.ZERO);
            resp.put("totalBackAmt", null != data.get("totalBackAmt") ? new BigDecimal(data.get("totalBackAmt").toString()) : BigDecimal.ZERO);
            resp.put("remanentAdvancePayAmt", resp.get("totalAdvancePayAmt").subtract(resp.get("totalBackAmt")));
        } else {
            resp.put("totalAdvancePayAmt", BigDecimal.ZERO);
            resp.put("totalBackAmt", BigDecimal.ZERO);
            resp.put("remanentAdvancePayAmt", BigDecimal.ZERO);
        }

        //查询项目下所有退保证金单据金额
        query = new QueryWrapper<>();
        query.select("sum(amount) as totalBackAmt");
        query.eq("project_id", projectId);
        query.eq("bill_type", PrjAdvancePaymentVO.BILL_TYPE_BACK_PAYMENT);
        query.eq("dr", BaseVO.DR_UNDELETE);
        data = super.getMap(query);
        if(null != data) {
            resp.put("remremainingRefundableAmt", null != data.get("totalBackAmt") ? new BigDecimal(data.get("totalBackAmt").toString()) : BigDecimal.ZERO);
        } else {
            resp.put("remremainingRefundableAmt", BigDecimal.ZERO);
        }
        resp.put("remremainingRefundableAmt", resp.get("totalAdvancePayAmt").subtract(resp.get("remremainingRefundableAmt")));

        return resp;
    }

    @Override
    public PrjAdvancePaymentVO getLastBillAccInfo(Long projectId, String billType) {
        PrjAdvancePaymentVO resp = null;
        QueryWrapper<PrjAdvancePaymentEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.and(q -> q.or(qe -> qe.eq("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode())).or(qe -> qe.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode())));
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.orderByDesc("create_time");
        query.last("limit 1");

        PrjAdvancePaymentEntity e = super.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, PrjAdvancePaymentVO.class);
        }

        return resp;
    }
}
