package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestSubEntity;
import com.ejianc.business.prjfinance.bean.PrjOtherCostEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.prjfinance.mapper.PrjLoanInterestMapper;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 借款利息结算
 * 
 * @author jxy
 * 
 */
@Service("prjLoanInterestService")
public class PrjLoanInterestServiceImpl extends BaseServiceImpl<PrjLoanInterestMapper, PrjLoanInterestEntity> implements IPrjLoanInterestService{
    @Autowired
    private IPrjLoanInterestSubService prjLoanInterestSubService;

    /**
     * 查询当前项目最新的日期
     * @param projectId
     * @return
     */
    public Map<String, String> queryLatelyDate(Long projectId) {
        Map<String, String> resp = new HashMap<>();
        QueryWrapper<PrjLoanInterestEntity> query = new QueryWrapper<>();
        query.select("  max(handle_date) as handleDate  ");
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);
        if(null != data) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");//设置日期格式
            resp.put("latelyDate",  df.format(data.get("handleDate")) );
        }
        return resp;
    }




}
