package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestSubEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneySubEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestService;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;
import com.ejianc.business.prjfinance.service.IReturnMoneyService;
import com.ejianc.business.prjfinance.service.IReturnMoneySubService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("projectLoan") 
public class ProjectLoanBpmServiceImpl implements ICommonBusinessService {



	@Autowired
	private IReturnMoneyService iReturnMoneyService;
	@Autowired
	private IReturnMoneySubService returnMoneySubService;
	@Autowired
	private IPrjLoanInterestSubService prjLoanInterestSubService;
	@Autowired
	private IPrjLoanInterestService iPrjLoanInterestService;

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		QueryParam param = new QueryParam();
		param.getParams().put("loanId",new Parameter(QueryParam.EQ,billId));
		List<ReturnMoneySubEntity> subEntities = returnMoneySubService.queryList(param);
		if(ListUtil.isNotEmpty(subEntities)){
			ReturnMoneyEntity moneyEntity = iReturnMoneyService.selectById(subEntities.get(0).getPid());
			return CommonResponse.error("无法弃审或者撤回：该单据已被编号为【"+moneyEntity.getCode()+"】的借款退还单引用！");
		}
		List<PrjLoanInterestSubEntity> interestSubEntities = prjLoanInterestSubService.queryList(param);
		if(ListUtil.isNotEmpty(interestSubEntities)){
			PrjLoanInterestEntity entity = iPrjLoanInterestService.selectById(interestSubEntities.get(0).getPid());
			return CommonResponse.error("无法弃审或者撤回：该单据已被编号为【"+entity.getCode()+"】的借款利息结算单引用！");
		}
		//TODO
		return CommonResponse.success();
	}

}
