package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.vo.ProjectLoanVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.prjfinance.mapper.ProjectLoanMapper;
import com.ejianc.business.prjfinance.bean.ProjectLoanEntity;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * 项目借款
 * 
 * @author generator
 * 
 */
@Service("projectLoanService")
public class ProjectLoanServiceImpl extends BaseServiceImpl<ProjectLoanMapper, ProjectLoanEntity> implements IProjectLoanService{

    /**
     * 更新借款单单据累计已还金额
     *
     * @param billId
     * @param returnMny
     */
    @Override
    @Transactional
    public synchronized void updateBillAllReturnMoney(Long billId, BigDecimal returnMny,int type) {
        ProjectLoanEntity entity = selectById(billId);
        if(returnMny==null){
            returnMny = BigDecimal.ZERO;
        }
        if(entity == null){
            throw new BusinessException("不存在的单据！");
        }
        if(returnMny!=null){
            if(type == IProjectLoanService.add){
                entity.setReturnMoney(entity.getReturnMoney()==null?returnMny:entity.getReturnMoney().add(returnMny));
            }else {
                entity.setReturnMoney(entity.getReturnMoney()==null?returnMny.multiply(new BigDecimal("-1")):entity.getReturnMoney().subtract(returnMny));
            }
            saveOrUpdate(entity);
        }
    }

    /**
     * 更新借款单单据累计已结利息
     *
     * @param billId
     * @param interestMny
     */
    @Override
    @Transactional
    public synchronized void updateBillAllInterestMoney(Long billId, BigDecimal interestMny,int type) {
        if(interestMny==null){
            interestMny = BigDecimal.ZERO;
        }
        ProjectLoanEntity entity = selectById(billId);
        if(entity == null){
            throw new BusinessException("不存在的单据！");
        }
        if(interestMny!=null){
            if(type == IProjectLoanService.subtract){
                entity.setInterest(entity.getInterest()==null?interestMny.multiply(new BigDecimal("-1")):entity.getInterest().subtract(interestMny));
            }else {
                entity.setInterest(entity.getInterest()==null?interestMny:entity.getInterest().add(interestMny));
            }
            saveOrUpdate(entity);
        }
    }

    @Override
    public IPage<ProjectLoanVO> queryForList(QueryParam param) {
        IPage<ProjectLoanVO> voPage = null ;
        IPage<ProjectLoanEntity> entityPage = super.queryPage(param,false);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(param.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), ProjectLoanVO.class));
        }
        return voPage;
    }

}
