package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.mapper.ProjectDutyLetterMapper;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service("projectDutyLetterService")
public class ProjectDutyLetterService extends BaseServiceImpl<ProjectDutyLetterMapper, ProjectDutyLetterEntity> implements IProjectDutyLetterService {

    @Override
    public ProjectDutyLetterEntity selectByPrjojectId(Long projectId) {
        QueryWrapper<ProjectDutyLetterEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }
}
