package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.prjfinance.bean.ProjectLoanEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneySubEntity;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.business.prjfinance.service.IReturnMoneyService;
import com.ejianc.business.prjfinance.service.IReturnMoneySubService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("returnMoney") 
public class ReturnMoneyBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IReturnMoneyService iReturnMoneyService;
	@Autowired
	private IReturnMoneySubService returnMoneySubService;
	@Autowired
	private IProjectLoanService iProjectLoanService;

	@Autowired
	private IProjectLoanService projectLoanService;
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnMoneyEntity main = iReturnMoneyService.selectById(billId);
		if(main == null){
			return CommonResponse.error("单据不存在！");
		}
		List<ReturnMoneySubEntity> subEntities = main.getReturnMoneySubEntities();
		if(ListUtil.isNotEmpty(subEntities)){
			for (ReturnMoneySubEntity subEntity : subEntities) {
				/** 累加到已还款金额 */
				iProjectLoanService.updateBillAllReturnMoney(subEntity.getLoanId(),subEntity.getReturnMny(),IProjectLoanService.add);

				if(subEntity.getLoanMoney().equals(subEntity.getReturnMny())){
					ProjectLoanEntity projectLoanEntity =projectLoanService.selectById(subEntity.getLoanId());
					projectLoanEntity.setLoanMoneyYornState(1);
					projectLoanService.saveOrUpdate(projectLoanEntity);
				}
			}

		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReturnMoneyEntity main = iReturnMoneyService.selectById(billId);
		if(main == null){
			return CommonResponse.error("单据不存在！");
		}
		QueryParam param = new QueryParam();
		param.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));
		param.getParams().put("projectId",new Parameter(QueryParam.EQ,main.getProjectId()));
		param.getOrderMap().put("dealDate",QueryParam.DESC);
		param.getOrderMap().put("createTime",QueryParam.DESC);
		List<ReturnMoneyEntity> list = iReturnMoneyService.queryList(param);
		if(ListUtil.isNotEmpty(list)){
			/** 不是最新审批通过的不能弃审 */
			if(!billId.equals(list.get(0).getId())){
				return CommonResponse.error("该单据不是最新已审核单据，无法弃审！");
			}
		}
		param.getParams().put("billState",new Parameter(QueryParam.IN,"0,2,4,5"));
		list = iReturnMoneyService.queryList(param);
		/** 存在自由态，审核中的不能弃审 */
		if(ListUtil.isNotEmpty(list)){
			return CommonResponse.error("存在未审核通过的单据不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode){
		ReturnMoneyEntity main = iReturnMoneyService.selectById(billId);
		if(main == null){
			return CommonResponse.error("单据不存在！");
		}
		List<ReturnMoneySubEntity> subEntities = main.getReturnMoneySubEntities();
		if(ListUtil.isNotEmpty(subEntities)){
			for (ReturnMoneySubEntity subEntity : subEntities) {
				/** 已还款金额减掉当前金额 */
				iProjectLoanService.updateBillAllReturnMoney(subEntity.getLoanId(),subEntity.getReturnMny(),IProjectLoanService.subtract);
				ProjectLoanEntity projectLoanEntity =projectLoanService.selectById(subEntity.getLoanId());
				projectLoanEntity.setLoanMoneyYornState(0);
				projectLoanService.saveOrUpdate(projectLoanEntity);

			}
		}

		return CommonResponse.success();
	};
}
