package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.mapper.ProjectDutyLetterMapper;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.OperationCostVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("projectDutyLetterService")
public class ProjectDutyLetterService extends BaseServiceImpl<ProjectDutyLetterMapper, ProjectDutyLetterEntity> implements IProjectDutyLetterService {

    @Override
    public ProjectDutyLetterEntity selectByPrjojectId(Long projectId) {
        QueryWrapper<ProjectDutyLetterEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }

    /**
     * 根据项目Id查询对应的联营项目费用列表
     */
    @Override
    public List<OperationCostVO> getOperationList(OperationCostVO operationCostVO) {
        return baseMapper.getOperationList(operationCostVO.getProjectId());
    }
}
