package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.bean.TaxCostEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.business.prjfinance.service.ITaxCostService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterChangeCostlistVO;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterCostlistVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.esotericsoftware.minlog.Log;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.logging.Logger;

@Service("taxCost")
public class TaxCostBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private ITaxCostService taxCostService;
    @Autowired
    private IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    private IProjectDutyLetterCostlistService projectDutyLetterCostlistService;

    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        TaxCostEntity taxCostEntity = taxCostService.selectById(billId);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in("project_id", taxCostEntity.getProjectId());
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        ProjectDutyLetterEntity projectDutyLetterServiceOne = projectDutyLetterService.getOne(queryWrapper);
        if (null != projectDutyLetterServiceOne) {
                ProjectDutyLetterCostlistVO projectDutyLetterCostlistVO = new ProjectDutyLetterCostlistVO();
                projectDutyLetterCostlistVO.setCostId(taxCostEntity.getCostId());
                projectDutyLetterCostlistVO.setAmount(taxCostEntity.getAmount());
                projectDutyLetterCostlistVO.setBackOrDel(taxCostEntity.getBackOrDel());
                projectDutyLetterCostlistVO.setCostName(taxCostEntity.getCostName());
                projectDutyLetterCostlistVO.setDutyLetterId(projectDutyLetterServiceOne.getId());
                projectDutyLetterCostlistVO.setRemarks(taxCostEntity.getMemo());
                projectDutyLetterCostlistVO.setTaxCostId(billId);
                projectDutyLetterCostlistVO.setCostTime(taxCostEntity.getCostTime());
                projectDutyLetterCostlistVO.setCostCode(taxCostEntity.getBillCode());
                projectDutyLetterCostlistService.saveOrUpdate(BeanMapper.map(projectDutyLetterCostlistVO, ProjectDutyLetterCostlistEntity.class));
        }

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        LambdaUpdateWrapper<ProjectDutyLetterCostlistEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ProjectDutyLetterCostlistEntity::getTaxCostId, billId);
        updateWrapper.set(ProjectDutyLetterCostlistEntity::getDr, BaseVO.DR_DELETED);
        projectDutyLetterCostlistService.update(updateWrapper);
        return CommonResponse.success();
    }

}
