/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.PrjOtherCostEntity;
import com.ejianc.business.prjfinance.mapper.PrjOtherCostMapper;
import com.ejianc.business.prjfinance.service.IPrjOtherCostService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherCostService")
public class PrjOtherCostServiceImpl
extends BaseServiceImpl<PrjOtherCostMapper, PrjOtherCostEntity>
implements IPrjOtherCostService {
    @Autowired
    private PrjOtherCostMapper costMapper;

    @Override
    public Map<String, BigDecimal> queryCumAmount(Long projectId, String billType) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"  sum(apply_mn) as totalAmount  "});
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"bill_types", (Object)billType);
        query.in((Object)"bill_state", new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        Map data = super.getMap((Wrapper)query);
        if (null != data) {
            resp.put("totalAmount", null != data.get("totalAmount") ? new BigDecimal(data.get("totalAmount").toString()) : BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalAmount", BigDecimal.ZERO);
        }
        return resp;
    }

    @Override
    public Map<String, BigDecimal> queryCumAmountListAll(QueryParam param) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        Map queryResult = null;
        QueryWrapper query = PrjOtherCostServiceImpl.changeToQueryWrapper((QueryParam)param);
        query.select(new String[]{" sum( CASE WHEN bill_types = 0 THEN apply_mn ELSE 0 END ) AS deductionAmount ,sum( CASE WHEN bill_types = 1 THEN apply_mn ELSE 0 END ) AS refundAmount "});
        queryResult = super.getMap((Wrapper)query);
        if (null != queryResult) {
            resp.put("deductionAmount", null != queryResult.get("deductionAmount") ? new BigDecimal(queryResult.get("deductionAmount").toString()) : BigDecimal.ZERO.setScale(8));
            resp.put("refundAmount", null != queryResult.get("refundAmount") ? new BigDecimal(queryResult.get("refundAmount").toString()) : BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("deductionAmount", BigDecimal.ZERO);
            resp.put("refundAmount", BigDecimal.ZERO);
        }
        return resp;
    }

    @Override
    public Map<String, BigDecimal> queryProjectCumAllAmount(Long projectId) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{" sum( CASE WHEN bill_types = 1 THEN apply_mn ELSE 0 END ) AS refundAmount ,sum( CASE WHEN bill_types = 0 THEN apply_mn ELSE 0 END ) AS deductionAmount "});
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        Map data = super.getMap((Wrapper)query);
        if (null != data) {
            resp.put("deductionAmount", null != data.get("deductionAmount") ? new BigDecimal(data.get("deductionAmount").toString()) : BigDecimal.ZERO.setScale(8));
            resp.put("refundAmount", null != data.get("refundAmount") ? new BigDecimal(data.get("refundAmount").toString()) : BigDecimal.ZERO.setScale(8));
            resp.put("cumDeductionMn", ((BigDecimal)resp.get("deductionAmount")).subtract((BigDecimal)resp.get("refundAmount")));
        } else {
            resp.put("deductionAmount", BigDecimal.ZERO);
            resp.put("refundAmount", BigDecimal.ZERO);
            resp.put("cumDeductionMn", BigDecimal.ZERO);
        }
        return resp;
    }

    @Override
    public List<PrjOtherCostEntity> queryProjectList(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("dr", new Parameter("in", (Object)"0"));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getOrderMap().put("handleDate", "desc");
        List list = this.queryList(param);
        return list;
    }
}

