package com.ejianc.business.prjfinance.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestService;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;
import com.ejianc.business.prjfinance.vo.PrjLoanInterestSubVO;
import com.ejianc.business.prjfinance.vo.PrjLoanInterestVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 借款利息结算
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("prjLoanInterest")
public class PrjLoanInterestController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IPrjLoanInterestService service;
    @Autowired
    private IPrjLoanInterestSubService prjLoanInterestSubService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    private static final String BILL_CODE = "loan-Interest-001";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PrjLoanInterestVO> saveOrUpdate(@RequestBody PrjLoanInterestVO saveorUpdateVO) {
    	PrjLoanInterestEntity entity = BeanMapper.map(saveorUpdateVO, PrjLoanInterestEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> code = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(code.isSuccess()) {
                entity.setCode(code.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        QueryParam param = new QueryParam();
        param.getParams().put("projectId",new Parameter(QueryParam.EQ,entity.getProjectId()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "0,2,4,5"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<PrjLoanInterestEntity> list = service.queryList(param);
        if(ListUtil.isNotEmpty(list)){
            if(entity.getId() == null || entity.getId() == 0){
                throw new BusinessException("存在未审批完成的借款利息【"+list.get(0).getCode()+"】，无法新增还利息！");
            }
            if(!entity.getId().equals(list.get(0).getId())){
                throw new BusinessException("存在未审批完成的借款利息【"+list.get(0).getCode()+"】，无法更新还利息！");
            }
        }

    	service.saveOrUpdate(entity,false);
    	PrjLoanInterestVO vo = BeanMapper.map(entity, PrjLoanInterestVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrjLoanInterestVO> queryDetail(Long id) {
    	PrjLoanInterestEntity entity = service.selectById(id);
    	PrjLoanInterestVO vo = BeanMapper.map(entity, PrjLoanInterestVO.class);
        listSubOrderCreateTimeBy(vo.getLoanInterestSubEntities());
    	return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjLoanInterestVO> vos) {
        service.removeByIds(vos.stream().map(PrjLoanInterestVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PrjLoanInterestVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("code");
        fuzzyFields.add("handleUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        IPage<PrjLoanInterestEntity> page = service.queryPage(param,false);
        IPage<PrjLoanInterestVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrjLoanInterestVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取系统最大时间
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryLatelyDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, String>> queryLatelyDate(Long projectId){
        Map<String,String> map =service.queryLatelyDate(projectId);
        return CommonResponse.success("查询最后结算日期成功！",map);
    }

    /**
     * 获取系统最大时间根据结算单
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryLatelyDate4Settle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<Long, String>> queryLatelyDate4Settle(Long projectId) {
        Map<Long, String> map = service.queryLatelyDate4Settle(projectId);
        return CommonResponse.success("查询最后结算日期成功！", map);
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<PrjLoanInterestEntity> pageData = service.queryPage(queryParam, false);
        List<PrjLoanInterestVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(loanInterest -> {
                PrjLoanInterestVO r = BeanMapper.map(loanInterest, PrjLoanInterestVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("loanInterest-export.xlsx", beans, response);
    }

    /**
     * 查询项目累计利息
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryCurrentInterest", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryCurrentInterest(Long projectId){
        Map<String,BigDecimal> map =prjLoanInterestSubService.queryCurrentInterest(projectId);
        return CommonResponse.success("查询最后结算日期成功！",map);
    }

    /**
     * 排序createDate 倒序
     * @param prjLoanInterestSubVOList
     */
    public void listSubOrderCreateTimeBy(List<PrjLoanInterestSubVO> prjLoanInterestSubVOList){

        if(CollectionUtils.isEmpty(prjLoanInterestSubVOList)){
            return;
        }

        Collections.sort(prjLoanInterestSubVOList, new Comparator<PrjLoanInterestSubVO>() {
            public int compare(PrjLoanInterestSubVO o1, PrjLoanInterestSubVO o2) {
                try {
                    long time1 = o1.getCreateTime().getTime();
                    long time2 = o2.getCreateTime().getTime();
                    if (time1 > time2) {
                        return -1;
                    } else if (time1 < time2) {
                        return 1;
                    } else {
                        return 0;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return 0;
            }
        });
    }
}
