package com.ejianc.business.prjfinance.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目还款子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjfinance_return_mny_sub")
public class ReturnMoneySubEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="loan_id")
    private Long loanId; // 借款单id
    @TableField(value="code")
    private String code; // 借款单号
    @TableField(value="name")
    private String name; // 借款单主题
    @TableField(value="loan_money")
    private BigDecimal loanMoney; // 借款金额
    @TableField(value="loan_balance")
    private BigDecimal loanBalance; // 借款结余
    @TableField(value="return_mny")
    private BigDecimal returnMny; // 本期还款金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="pid")
    private Long pid; // 主表id

    @TableField(value="account_out_id")
    private Long accountOutId; // 调出账户
    @TableField(value="account_out_name")
    private String accountOutName; // 调出账户名称
    @TableField(value="account_out_bank")
    private String accountOutBank; // 开户行（调出账户）
    @TableField(value="account_out_num")
    private String accountOutNum; // 账号（调出账户）
    @TableField(value="account_in_id")
    private Long accountInId; // 调入账户
    @TableField(value="account_in_name")
    private String accountInName; // 调入账户名称
    @TableField(value="account_in_bank")
    private String accountInBank; // 开户行（调入账户）
    @TableField(value="account_in_num")
    private String accountInNum; // 账号（调入账户）

    public Long getAccountOutId() {
        return accountOutId;
    }

    public void setAccountOutId(Long accountOutId) {
        this.accountOutId = accountOutId;
    }

    public String getAccountOutName() {
        return accountOutName;
    }

    public void setAccountOutName(String accountOutName) {
        this.accountOutName = accountOutName;
    }

    public String getAccountOutBank() {
        return accountOutBank;
    }

    public void setAccountOutBank(String accountOutBank) {
        this.accountOutBank = accountOutBank;
    }

    public String getAccountOutNum() {
        return accountOutNum;
    }

    public void setAccountOutNum(String accountOutNum) {
        this.accountOutNum = accountOutNum;
    }

    public Long getAccountInId() {
        return accountInId;
    }

    public void setAccountInId(Long accountInId) {
        this.accountInId = accountInId;
    }

    public String getAccountInName() {
        return accountInName;
    }

    public void setAccountInName(String accountInName) {
        this.accountInName = accountInName;
    }

    public String getAccountInBank() {
        return accountInBank;
    }

    public void setAccountInBank(String accountInBank) {
        this.accountInBank = accountInBank;
    }

    public String getAccountInNum() {
        return accountInNum;
    }

    public void setAccountInNum(String accountInNum) {
        this.accountInNum = accountInNum;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 借款单id
     */
    public Long getLoanId() {
        return loanId;
    }

    /**
     * 借款单id
     */
    public void setLoanId(Long loanId) {
        this.loanId = loanId;
    }
    /**
     * 借款单号
     */
    public String getCode() {
        return code;
    }

    /**
     * 借款单号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 借款单主题
     */
    public String getName() {
        return name;
    }

    /**
     * 借款单主题
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 借款金额
     */
    public BigDecimal getLoanMoney() {
        return loanMoney;
    }

    /**
     * 借款金额
     */
    public void setLoanMoney(BigDecimal loanMoney) {
        this.loanMoney = loanMoney;
    }
    /**
     * 借款结余
     */
    public BigDecimal getLoanBalance() {
        return loanBalance;
    }

    /**
     * 借款结余
     */
    public void setLoanBalance(BigDecimal loanBalance) {
        this.loanBalance = loanBalance;
    }

    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
