package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.bank.api.IBankAccFinApi;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.prjfinance.bean.*;
import com.ejianc.business.prjfinance.service.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("projectLoan") 
public class ProjectLoanBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IReturnMoneyService iReturnMoneyService;
	@Autowired
	private IReturnMoneySubService returnMoneySubService;
	@Autowired
	private IPrjLoanInterestSubService prjLoanInterestSubService;
	@Autowired
	private IPrjLoanInterestService iPrjLoanInterestService;

	@Autowired
	private IBankAccFinApi bankAccFinApi;

	@Autowired
	private IProjectLoanService service;

	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("进入终审后回写--- billId:"+billId+"  state:"+state);
		ProjectLoanEntity entity = service.selectById(billId);
		if((entity.getAccountInId() != null || entity.getAccountOutId() != null) && ComputeUtil.isGreaterThan(entity.getLoanMoney(), BigDecimal.ZERO)){
			//==================推送收支流水
			// 收入
			List<BankFlowVO> bankFlowVOS = new ArrayList<>();
			BankFlowVO flowVO= BankFlowVO.instanceVOBySourceType(BankFlowSourceType.项目借款收入);
			flowVO.setBillDate(entity.getProcessDate());
			flowVO.setSourceId(entity.getId());
			flowVO.setBillId(entity.getId());
			flowVO.setReceiveMoney(entity.getLoanMoney());
			flowVO.setBillCode(entity.getCode());
			flowVO.setOrgId(entity.getOrgId());
			flowVO.setOrgName(entity.getProjectName());
			flowVO.setAccountId(entity.getAccountInId());
			flowVO.setAccountName(entity.getAccountInName());
			flowVO.setAccountBank(entity.getAccountInBank());
			flowVO.setAccountNum(entity.getAccountInNum());

			flowVO.setTradeAccountId(entity.getAccountOutId());
			flowVO.setTradeAccountName(entity.getAccountOutName());
			flowVO.setTradeAccountBank(entity.getAccountOutBank());
			flowVO.setTradeAccountNum(entity.getAccountOutNum());
			flowVO.setMemo(entity.getMemo());
			flowVO.setEmployeeId(entity.getAgentId());
			flowVO.setEmployeeName(entity.getAgentName());
			bankFlowVOS.add(flowVO);

			// 支出
			BankFlowVO flowOutVO= BankFlowVO.instanceVOBySourceType(BankFlowSourceType.项目借款支出);
			flowOutVO.setBillDate(entity.getProcessDate());
			flowOutVO.setSourceId(entity.getId());
			flowOutVO.setBillId(entity.getId());
			flowOutVO.setPayMoney(entity.getLoanMoney());
			flowOutVO.setBillCode(entity.getCode());
			flowOutVO.setOrgId(entity.getOrgId());
			flowOutVO.setOrgName(entity.getProjectName());
			flowOutVO.setAccountId(entity.getAccountOutId());
			flowOutVO.setAccountName(entity.getAccountOutName());
			flowOutVO.setAccountBank(entity.getAccountOutBank());
			flowOutVO.setAccountNum(entity.getAccountOutNum());

			flowOutVO.setTradeAccountId(entity.getAccountInId());
			flowOutVO.setTradeAccountName(entity.getAccountInName());
			flowOutVO.setTradeAccountBank(entity.getAccountInBank());
			flowOutVO.setTradeAccountNum(entity.getAccountInNum());
			flowOutVO.setMemo(entity.getMemo());
			flowOutVO.setEmployeeId(entity.getAgentId());
			flowOutVO.setEmployeeName(entity.getAgentName());
			bankFlowVOS.add(flowOutVO);
			bankAccFinApi.batchSaveBankFlow(bankFlowVOS);
			//===============推送收支流水结束
		}

		return CommonResponse.success();
	}

	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		bankAccFinApi.delBankFlow(billId, billId);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		QueryParam param = new QueryParam();
		param.getParams().put("loanId",new Parameter(QueryParam.EQ,billId));
		List<ReturnMoneySubEntity> subEntities = returnMoneySubService.queryList(param);
		if(ListUtil.isNotEmpty(subEntities)){
			ReturnMoneyEntity moneyEntity = iReturnMoneyService.selectById(subEntities.get(0).getPid());
			return CommonResponse.error("无法弃审或者撤回：该单据已被编号为【"+moneyEntity.getCode()+"】的借款退还单引用！");
		}
		List<PrjLoanInterestSubEntity> interestSubEntities = prjLoanInterestSubService.queryList(param);
		if(ListUtil.isNotEmpty(interestSubEntities)){
			PrjLoanInterestEntity entity = iPrjLoanInterestService.selectById(interestSubEntities.get(0).getPid());
			return CommonResponse.error("无法弃审或者撤回：该单据已被编号为【"+entity.getCode()+"】的借款利息结算单引用！");
		}
		return CommonResponse.success();
	}



}
