/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.ejianc.business.bank.api.IBankAccFinApi;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestEntity;
import com.ejianc.business.prjfinance.bean.PrjLoanInterestSubEntity;
import com.ejianc.business.prjfinance.bean.ProjectLoanEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneyEntity;
import com.ejianc.business.prjfinance.bean.ReturnMoneySubEntity;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestService;
import com.ejianc.business.prjfinance.service.IPrjLoanInterestSubService;
import com.ejianc.business.prjfinance.service.IProjectLoanService;
import com.ejianc.business.prjfinance.service.IReturnMoneyService;
import com.ejianc.business.prjfinance.service.IReturnMoneySubService;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectLoan")
public class ProjectLoanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReturnMoneyService iReturnMoneyService;
    @Autowired
    private IReturnMoneySubService returnMoneySubService;
    @Autowired
    private IPrjLoanInterestSubService prjLoanInterestSubService;
    @Autowired
    private IPrjLoanInterestService iPrjLoanInterestService;
    @Autowired
    private IBankAccFinApi bankAccFinApi;
    @Autowired
    private IProjectLoanService service;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u7ec8\u5ba1\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        ProjectLoanEntity entity = (ProjectLoanEntity)((Object)this.service.selectById(billId));
        if ((entity.getAccountInId() != null || entity.getAccountOutId() != null) && ComputeUtil.isGreaterThan((BigDecimal)entity.getLoanMoney(), (BigDecimal)BigDecimal.ZERO)) {
            ArrayList<BankFlowVO> bankFlowVOS = new ArrayList<BankFlowVO>();
            BankFlowVO flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u9879\u76ee\u501f\u6b3e\u6536\u5165);
            flowVO.setBillDate(entity.getProcessDate());
            flowVO.setSourceId(entity.getId());
            flowVO.setBillId(entity.getId());
            flowVO.setReceiveMoney(entity.getLoanMoney());
            flowVO.setBillCode(entity.getCode());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getProjectName());
            flowVO.setAccountId(entity.getAccountInId());
            flowVO.setAccountName(entity.getAccountInName());
            flowVO.setAccountBank(entity.getAccountInBank());
            flowVO.setAccountNum(entity.getAccountInNum());
            flowVO.setTradeAccountId(entity.getAccountOutId());
            flowVO.setTradeAccountName(entity.getAccountOutName());
            flowVO.setTradeAccountBank(entity.getAccountOutBank());
            flowVO.setTradeAccountNum(entity.getAccountOutNum());
            flowVO.setMemo(entity.getMemo());
            flowVO.setEmployeeId(entity.getAgentId());
            flowVO.setEmployeeName(entity.getAgentName());
            bankFlowVOS.add(flowVO);
            BankFlowVO flowOutVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u9879\u76ee\u501f\u6b3e\u652f\u51fa);
            flowOutVO.setBillDate(entity.getProcessDate());
            flowOutVO.setSourceId(entity.getId());
            flowOutVO.setBillId(entity.getId());
            flowOutVO.setPayMoney(entity.getLoanMoney());
            flowOutVO.setBillCode(entity.getCode());
            flowOutVO.setOrgId(entity.getOrgId());
            flowOutVO.setOrgName(entity.getProjectName());
            flowOutVO.setAccountId(entity.getAccountOutId());
            flowOutVO.setAccountName(entity.getAccountOutName());
            flowOutVO.setAccountBank(entity.getAccountOutBank());
            flowOutVO.setAccountNum(entity.getAccountOutNum());
            flowOutVO.setTradeAccountId(entity.getAccountInId());
            flowOutVO.setTradeAccountName(entity.getAccountInName());
            flowOutVO.setTradeAccountBank(entity.getAccountInBank());
            flowOutVO.setTradeAccountNum(entity.getAccountInNum());
            flowOutVO.setMemo(entity.getMemo());
            flowOutVO.setEmployeeId(entity.getAgentId());
            flowOutVO.setEmployeeName(entity.getAgentName());
            bankFlowVOS.add(flowOutVO);
            this.bankAccFinApi.batchSaveBankFlow(bankFlowVOS);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.bankAccFinApi.delBankFlow(billId, billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QueryParam param = new QueryParam();
        param.getParams().put("loanId", new Parameter("eq", (Object)billId));
        List subEntities = this.returnMoneySubService.queryList(param);
        if (ListUtil.isNotEmpty((List)subEntities)) {
            ReturnMoneyEntity moneyEntity = (ReturnMoneyEntity)((Object)this.iReturnMoneyService.selectById(((ReturnMoneySubEntity)((Object)subEntities.get(0))).getPid()));
            return CommonResponse.error((String)("\u65e0\u6cd5\u5f03\u5ba1\u6216\u8005\u64a4\u56de\uff1a\u8be5\u5355\u636e\u5df2\u88ab\u7f16\u53f7\u4e3a\u3010" + moneyEntity.getCode() + "\u3011\u7684\u501f\u6b3e\u9000\u8fd8\u5355\u5f15\u7528\uff01"));
        }
        List interestSubEntities = this.prjLoanInterestSubService.queryList(param);
        if (ListUtil.isNotEmpty((List)interestSubEntities)) {
            PrjLoanInterestEntity entity = (PrjLoanInterestEntity)((Object)this.iPrjLoanInterestService.selectById(((PrjLoanInterestSubEntity)((Object)interestSubEntities.get(0))).getPid()));
            return CommonResponse.error((String)("\u65e0\u6cd5\u5f03\u5ba1\u6216\u8005\u64a4\u56de\uff1a\u8be5\u5355\u636e\u5df2\u88ab\u7f16\u53f7\u4e3a\u3010" + entity.getCode() + "\u3011\u7684\u501f\u6b3e\u5229\u606f\u7ed3\u7b97\u5355\u5f15\u7528\uff01"));
        }
        return CommonResponse.success();
    }
}

