package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjfinance.bean.PrjQualitySafetyPenaltyEntity;
import com.ejianc.business.prjfinance.service.IPrjQualitySafetyPenaltyService;
import com.ejianc.business.prjfinance.vo.PrjQualitySafetyPenaltyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 质安罚款
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("prjQualitySafetyPenalty")
public class PrjQualitySafetyPenaltyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPrjQualitySafetyPenaltyService service;

    @Autowired
    private IOrgApi orgApi;

    private static final String BILL_CODE = "quality-safety-penalty-001";


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PrjQualitySafetyPenaltyVO> saveOrUpdate(@RequestBody PrjQualitySafetyPenaltyVO saveorUpdateVO) {

        PrjQualitySafetyPenaltyEntity entity = BeanMapper.map(saveorUpdateVO, PrjQualitySafetyPenaltyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

    	service.saveOrUpdate(entity, false);
    	PrjQualitySafetyPenaltyVO vo = BeanMapper.map(entity, PrjQualitySafetyPenaltyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrjQualitySafetyPenaltyVO> queryDetail(Long id) {
    	PrjQualitySafetyPenaltyEntity entity = service.selectById(id);
    	PrjQualitySafetyPenaltyVO vo = BeanMapper.map(entity, PrjQualitySafetyPenaltyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjQualitySafetyPenaltyVO> vos) {
        service.removeByIds(vos.stream().map(PrjQualitySafetyPenaltyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("dealPerson");
        /** 租户隔离 */
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<PrjQualitySafetyPenaltyEntity> page = service.queryPage(param,false);
        IPage<PrjQualitySafetyPenaltyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrjQualitySafetyPenaltyVO.class));
        Map<String, BigDecimal> totalPenaltyMny = service.queryTotalPenaltyMnyAll(param);
        resp.put("total", pageData.getTotal());
        resp.put("current", pageData.getCurrent());
        resp.put("size", pageData.getSize());
        resp.put("pages", pageData.getPages());
        resp.put("records", pageData.getRecords());
        resp.put("totalPenaltyMny", totalPenaltyMny.get("totalPenaltyMny"));
        return CommonResponse.success("查询列表数据成功！",resp);
    }

    /**
     * 累计罚款金额
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryTotalPenaltyMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryCurrentInterest(Long projectId){
        Map<String,BigDecimal> map =service.queryTotalPenaltyMny(projectId);
        return CommonResponse.success("查询累计罚款金额成功！",map);
    }

    /**
     * 查询列表提供给项目责任书
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryProjectDutyLetterList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PrjQualitySafetyPenaltyEntity>> queryProjectDutyLetterList(Long projectId){
        List<PrjQualitySafetyPenaltyEntity> list =service.queryProjectList(projectId);
        return CommonResponse.success("查询累计罚款金额成功！",list);
    }

    /**
     * 导出
     * @param queryParam
     * @param response
     */
    @PostMapping(value = "excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("name");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<PrjQualitySafetyPenaltyEntity> pageData = service.queryPage(queryParam, false);
        List<PrjQualitySafetyPenaltyVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(prjQualitySafetyPenalty -> {
                PrjQualitySafetyPenaltyVO r = BeanMapper.map(prjQualitySafetyPenalty, PrjQualitySafetyPenaltyVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode(r.getBillState()).getDescription());
                voList.add(r);
            });
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("prjQualitySafetyPenalty-export.xlsx", beans, response);
    }
}
