package com.ejianc.business.win.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author baipengyan
 * @date 2022/7/20
 * @description 中标登记
 */
public enum WinEnum {
	NO("0", "否"),
	YES("1", "是");

	private final String code;
	private final String desc;

	WinEnum(String code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	public String getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}

	private static Map<String, WinEnum> enumMap = new HashMap<>();

	static {
		enumMap = EnumSet.allOf(WinEnum.class).stream().collect(Collectors.toMap(WinEnum::getCode, Function.identity(), (k1, k2) -> k2));
	}

	public static WinEnum getEnumByCode(String code) {
		return enumMap.get(code);
	}
}
