package com.ejianc.business.pay.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author baipengyan
 * @date 2022/7/16
 * @description 风险金缴纳
 */
public enum PayEnum {
	CASH("0", "现金"),
	BACKLETTER("1", "保函"),
	INSURANCE("2", "保险");

	private final String code;
	private final String desc;

	PayEnum(String code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	public String getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}

	private static Map<String, PayEnum> enumMap = new HashMap<>();

	static {
		enumMap = EnumSet.allOf(PayEnum.class).stream().collect(Collectors.toMap(PayEnum::getCode, Function.identity(), (k1, k2) -> k2));
	}

	public static PayEnum getEnumByCode(String code) {
		return enumMap.get(code);
	}
}
