/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.bean.TerminateEntity;
import com.ejianc.business.bid.enums.BidStatusEnum;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.service.ITerminateService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminate")
public class TerminateBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectService projectService;
    @Autowired
    private ITerminateService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u6295\u6807\u4e2d\u6b62\uff0c\u63d0\u4ea4\u524d\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        TerminateEntity terminateEntity = (TerminateEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        terminateEntity.setCommitDate(new Date());
        terminateEntity.setCommitUserCode(userContext.getUserCode());
        terminateEntity.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)terminateEntity, false);
        return CommonResponse.success((String)"\u6295\u6807\u4e2d\u6b62\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TerminateEntity terminateEntity = (TerminateEntity)((Object)this.service.selectById(billId));
        if (terminateEntity != null) {
            terminateEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            terminateEntity.setCommitDate(new Date());
            terminateEntity.setCommitUserCode(userContext.getUserCode());
            terminateEntity.setCommitUserName(userContext.getUserName());
        }
        ProjectEntity entity = new ProjectEntity();
        entity.setId(terminateEntity.getProjectId());
        entity.setBidStatus(BidStatusEnum.\u5df2\u4e2d\u6b62.getTypeName());
        this.logger.info("\u4fee\u6539\u9879\u76eeid----{} \u6295\u6807\u72b6\u6001---{}", (Object)entity.getId(), (Object)entity.getBidStatus());
        this.projectService.updateBidStatus(entity);
        this.service.saveOrUpdate((Object)terminateEntity, false);
        return CommonResponse.success((String)"\u6295\u6807\u4e2d\u6b62\u7ec8\u5ba1\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        TerminateEntity terminateEntity = (TerminateEntity)((Object)this.service.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        ProjectEntity entity = new ProjectEntity();
        entity.setId(terminateEntity.getProjectId());
        entity.setBidStatus(BidStatusEnum.\u6295\u6807\u4e2d.getTypeName());
        this.projectService.updateBidStatus(entity);
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

