package com.ejianc.business.record.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.record.bean.RecordEntity;
import com.ejianc.business.record.mapper.RecordMapper;
import com.ejianc.business.record.service.IRecordService;
import com.ejianc.business.record.vo.RecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 工程投标备案实体
 *
 * @author generator
 */
@Service("recordService")
public class RecordServiceImpl extends BaseServiceImpl<RecordMapper, RecordEntity> implements IRecordService {

	/**
	 * 根据投标立项项目id查询工程投标备案记录
	 *
	 * @param projectId 投标立项项目id
	 */
	@Override
	public RecordVO queryDetailByProjectId(Long projectId) {
		QueryWrapper<RecordEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("project_id", projectId);
		return BeanMapper.map(super.selectById(super.getOne(wrapper).getId()), RecordVO.class);
	}
}
