/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.api.WinCaseVO;
import com.ejianc.business.win.enums.WinEnum;
import com.ejianc.business.win.service.IWinService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"winCase"})
public class WinCaseController
implements Serializable {
    private static final long serialVersionUID = -25982881142544835L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IOrgApi iOrgApi;
    private final IDefdocApi defdocApi;
    private final SessionManager sessionManager;
    private final IWinService winService;
    private static final Long DEF_ID = 315181000557633607L;
    private static final String SPECIALITY = "speciality";
    private static final String VALUE = "value";
    private static final String SUM = "sum";

    public WinCaseController(IOrgApi iOrgApi, IDefdocApi defdocApi, SessionManager sessionManager, IWinService winService) {
        this.iOrgApi = iOrgApi;
        this.defdocApi = defdocApi;
        this.sessionManager = sessionManager;
        this.winService = winService;
    }

    @GetMapping(value={"/fetchWinCase"})
    public CommonResponse<List<WinCaseVO>> fetchWinCase(@RequestParam(value="orgId") Long orgId, @RequestParam(value="time") Integer time) {
        CommonResponse response = this.defdocApi.getDefDocByDefId(DEF_ID);
        if (!response.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            throw new BusinessException("\u6839\u636e\u6863\u6848id\uff1a" + DEF_ID + "\uff0c\u67e5\u8be2\u5931\u8d25\uff01");
        }
        List defdocDetails = (List)response.getData();
        Map defdocDetailMap = defdocDetails.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        QueryWrapper qw = Wrappers.query();
        qw.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        qw.eq((Object)"dr", (Object)0);
        qw.in((Object)"bid_unit_id", (Collection)((List)this.iOrgApi.findChildrenByParentId(orgId != null ? orgId : InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        qw.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        qw.eq((Object)"bid_win_flag", (Object)WinEnum.YES.getCode());
        if (time != null) {
            if (time == 1) {
                qw.between((Object)"handle_date", (Object)WinCaseController.getMonthStartTime(dateTimeFormatter), (Object)WinCaseController.getMonthEndTime(dateTimeFormatter));
            } else if (time == 2) {
                qw.between((Object)"handle_date", (Object)WinCaseController.getFromThisQuarterStartTime(nowDate, dateTimeFormatter), (Object)WinCaseController.getFromThisQuarterEndTime(nowDate, dateTimeFormatter));
            } else {
                qw.between((Object)"handle_date", (Object)WinCaseController.getFromThisYearStartTime(nowDate, dateTimeFormatter), (Object)WinCaseController.getFromThisYearEndTime(nowDate, dateTimeFormatter));
            }
        }
        qw.select(new String[]{"project_type_id as speciality, sum(bid_win_mny) as value, count(*) as sum"});
        qw.groupBy((Object[])new String[]{"project_type_id"});
        List map = this.winService.listMaps((Wrapper)qw);
        ArrayList<WinCaseVO> winCaseVOS = new ArrayList<WinCaseVO>();
        for (Map mp : map) {
            WinCaseVO winCaseVO = new WinCaseVO();
            if (!defdocDetailMap.containsKey(Long.valueOf(mp.get(SPECIALITY).toString()))) continue;
            DefdocDetailVO defdocDetailVO = (DefdocDetailVO)defdocDetailMap.get(Long.valueOf(mp.get(SPECIALITY).toString()));
            winCaseVO.setSpeciality(Long.valueOf(mp.get(SPECIALITY).toString()));
            winCaseVO.setName(defdocDetailVO.getName());
            winCaseVO.setValue(new BigDecimal(mp.get(VALUE).toString()));
            winCaseVO.setSum(Integer.valueOf(mp.get(SUM).toString()));
            winCaseVOS.add(winCaseVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", winCaseVOS);
    }

    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, 0);
        cal.add(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    private static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, 0);
        cal.add(2, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }

    public static String getFromThisQuarterStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);
    }

    public static String getFromThisQuarterEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    public static String getFromThisYearStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    public static String getFromThisYearEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }
}

