/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.open.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.enums.EffectFlagEnum;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.utils.MybatisPlusColumnResolver;
import com.ejianc.business.open.bean.OpenEntity;
import com.ejianc.business.open.service.IOpenService;
import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.service.IProcessService;
import com.ejianc.business.win.bean.WinEntity;
import com.ejianc.business.win.service.IWinService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="open")
public class OpenBpmServiceImpl
implements ICommonBusinessService {
    private final IOpenService service;
    private final IProjectService projectService;
    private final IProcessService processService;
    private final IWinService winService;
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final MybatisPlusColumnResolver mybatisPlusColumnResolver;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public OpenBpmServiceImpl(IOpenService service, IProjectService projectService, IProcessService processService, IWinService winService, SessionManager sessionManager, IBillTypeApi billTypeApi, MybatisPlusColumnResolver mybatisPlusColumnResolver) {
        this.service = service;
        this.projectService = projectService;
        this.processService = processService;
        this.winService = winService;
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.mybatisPlusColumnResolver = mybatisPlusColumnResolver;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        OpenEntity entity = (OpenEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        MybatisPlusColumnResolver.ColumnResolver columnResolver = this.mybatisPlusColumnResolver.create();
        this.projectService.updateEffectFlag(entity.getProjectId(), columnResolver.columnToString(ProjectEntity::getOpenFlag), EffectFlagEnum.EFFECT.getCode());
        this.saveProcess(entity, "\u5f00\u6807\u8bb0\u5f55", "open/card");
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        OpenEntity entity = (OpenEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WinEntity::getProjectId, (Object)entity.getProjectId());
        List entityList = this.winService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e2d\u6807\u767b\u8bb0\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        MybatisPlusColumnResolver.ColumnResolver columnResolver = this.mybatisPlusColumnResolver.create();
        this.projectService.updateEffectFlag(entity.getProjectId(), columnResolver.columnToString(ProjectEntity::getOpenFlag), EffectFlagEnum.INVALID.getCode());
        this.delProcess(entity.getId());
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de\u6210\u529f");
    }

    private void saveProcess(OpenEntity entity, String billName, String frontendUrl) {
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(billName);
        processEntity.setProjectId(entity.getProjectId());
        processEntity.setProjectCode(entity.getProjectCode());
        processEntity.setProjectName(entity.getProjectName());
        processEntity.setFrontendUrl(frontendUrl);
        this.processService.saveOrUpdate((Object)processEntity);
    }

    private void delProcess(Long billId) {
        LambdaQueryWrapper l = new LambdaQueryWrapper();
        l.eq(ProcessEntity::getBillId, (Object)billId);
        this.processService.remove((Wrapper)l);
    }
}

