package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.vo.BusinessVO;
import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.service.IProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.BusinessMapper;
import com.ejianc.business.bid.bean.BusinessEntity;
import com.ejianc.business.bid.service.IBusinessService;

/**
 * 商机登记
 * 
 * @author generator
 * 
 */
@Service("businessService")
public class BusinessServiceImpl extends BaseServiceImpl<BusinessMapper, BusinessEntity> implements IBusinessService{
    @Autowired
    private IProcessService processService;
    @Override
    public void updateRefFlag(BusinessVO entity) {
        LambdaUpdateWrapper<BusinessEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BusinessEntity::getId, entity.getId());
        updateWrapper.set(BusinessEntity::getRefFlag, entity.getRefFlag());
        updateWrapper.set(BusinessEntity::getProjectId, entity.getProjectId());
        updateWrapper.set(BusinessEntity::getProjectCode, entity.getProjectCode());
        super.update(updateWrapper);
    }

    @Override
    public void saveProcess(BusinessEntity entity, String billName, String frontendUrl) {
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(billName);
        processEntity.setProjectId(entity.getProjectId());
        processEntity.setProjectCode(entity.getProjectCode());
        processEntity.setProjectName(entity.getProjectName());
        processEntity.setFrontendUrl(frontendUrl);
        processService.saveOrUpdate(processEntity);
    }

    /**
     * 根据单据id删除对应投标流程记录
     *
     * @param billId 单据id
     */
    @Override
    public void delProcess(Long billId) {
        LambdaQueryWrapper<ProcessEntity> l = new LambdaQueryWrapper<>();
        l.eq(ProcessEntity::getBillId, billId);
        processService.remove(l);
    }
}
