package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.mapper.ProjectMapper;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.service.IRegisDataService;
import com.ejianc.business.bid.vo.ProjectVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;

/**
 * 投标立项
 *
 * @author generator
 *
 */
@Service("projectService")
public class ProjectServiceImpl extends BaseServiceImpl<ProjectMapper, ProjectEntity> implements IProjectService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRegisDataService dataService;
    @Override
    public void updateBidStatus(ProjectVO entity) {
        LambdaUpdateWrapper<ProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ProjectEntity::getId, entity.getId());
        if (entity.getBidStatus()!=null){
            updateWrapper.set(ProjectEntity::getBidStatus, entity.getBidStatus());

        }
        if (entity.getPrequalificationFlag()!=null){
            updateWrapper.set(ProjectEntity::getPrequalificationFlag, entity.getPrequalificationFlag());
            logger.info("项目：{}修改 资格预审:{}",entity.getId(),entity.getPrequalificationFlag());
        }
        if (entity.getRegistDataFlag()!=null){
            QueryWrapper registrationQuery = new QueryWrapper();

            if (entity.getMemo().equals("add")){
                updateWrapper.set(ProjectEntity::getRegistDataFlag, entity.getRegistDataFlag());
            }else {
                ArrayList<Integer> billState = new ArrayList<>();
                billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                registrationQuery.eq("project_id",entity.getId());
                registrationQuery.eq("dr",0);
                registrationQuery.in("bill_state", billState);
                int countReg = dataService.count(registrationQuery);
                if (countReg>0){
                    updateWrapper.set(ProjectEntity::getRegistDataFlag,1);
                }else {
                    updateWrapper.set(ProjectEntity::getRegistDataFlag,0);
                }
            }
        }
        if (entity.getTenderFlag()!=null){
            updateWrapper.set(ProjectEntity::getTenderFlag, entity.getTenderFlag());
            logger.info("项目：{}修改 标书:{}",entity.getId(),entity.getTenderFlag());

        }
        super.update(updateWrapper);
    }


	/**
	 * 根据项目id更新状态
	 *
	 * @param projectId  项目id
	 * @param column     列名
	 * @param effectFlag 审批状态
	 */
	@Override
	public void updateEffectFlag(Long projectId, String column, Integer effectFlag) {
		UpdateWrapper<ProjectEntity> updateWrapper = new UpdateWrapper<>();
		updateWrapper.eq("id", projectId);
		updateWrapper.set(column, effectFlag);
		super.update(updateWrapper);
	}
}
