package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.TenderEntity;
import com.ejianc.business.bid.mapper.TenderMapper;
import com.ejianc.business.bid.service.ITenderService;
import com.ejianc.business.bid.vo.TenderVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 标书购买
 *
 * @author generator
 */
@Service("tenderService")
public class TenderServiceImpl extends BaseServiceImpl<TenderMapper, TenderEntity> implements ITenderService {

	/**
	 * 根据投标立项项目id查询工程投标备案记录
	 *
	 * @param projectId 投标立项项目id
	 */
	@Override
	public TenderVO queryDetailByProjectId(Long projectId) {
		QueryWrapper<TenderEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("project_id", projectId);
		return BeanMapper.map(super.getOne(wrapper), TenderVO.class);
	}
}
