package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bid.bean.BusinessEntity;
import com.ejianc.business.bid.bean.ProjectEntity;
import com.ejianc.business.bid.bean.TerminateEntity;
import com.ejianc.business.bid.enums.BidStatusEnum;
import com.ejianc.business.bid.service.IProjectService;
import com.ejianc.business.bid.service.ITerminateService;
import com.ejianc.business.bid.vo.ProjectVO;
import com.ejianc.business.process.bean.ProcessEntity;
import com.ejianc.business.process.service.IProcessService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service("terminate") 
public class TerminateBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private SessionManager sessionManager;
    @Autowired
    private IProjectService projectService;
    @Autowired
    private ITerminateService service;
	@Autowired
	private IProcessService processService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success("投标中止，提交前回调成功");
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		TerminateEntity terminateEntity = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		terminateEntity.setCommitDate(new Date());
		terminateEntity.setCommitUserCode(userContext.getUserCode());
		terminateEntity.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(terminateEntity, false);
		return CommonResponse.success("投标中止审批回调处理成功");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		TerminateEntity terminateEntity = service.selectById(billId);
		if (terminateEntity != null) {
			terminateEntity.setEffectiveDate(new Date());
		}
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			UserContext userContext = sessionManager.getUserContext();
			terminateEntity.setCommitDate(new Date());
			terminateEntity.setCommitUserCode(userContext.getUserCode());
			terminateEntity.setCommitUserName(userContext.getUserName());
		}
		ProjectVO entity = new ProjectVO();
		entity.setId(terminateEntity.getProjectId());
		entity.setBidStatus(BidStatusEnum.已中止.getTypeName());
		logger.info("修改项目id----{} 投标状态---{}",entity.getId(),entity.getBidStatus());
		projectService.updateBidStatus(entity);
		service.saveOrUpdate(terminateEntity, false);
		saveProcess(terminateEntity,"投标中止","terminate/card");
		return CommonResponse.success("投标中止终审回调成功");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		TerminateEntity terminateEntity = service.selectById(billId);
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		ProjectVO entity = new ProjectVO();
		entity.setId(terminateEntity.getProjectId());
		entity.setBidStatus(BidStatusEnum.投标中.getTypeName());
		projectService.updateBidStatus(entity);
		delProcess(entity.getId());
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}
	/**
	 * 新增投标记录
	 *
	 * @param entity      实体
	 * @param billName    单据名称
	 * @param frontendUrl 前端路由
	 */
	private void saveProcess(TerminateEntity entity, String billName, String frontendUrl) {
		ProcessEntity processEntity = new ProcessEntity();
		processEntity.setBillId(entity.getId());
		processEntity.setBillName(billName);
		processEntity.setProjectId(entity.getProjectId());
		processEntity.setProjectCode(entity.getProjectCode());
		processEntity.setProjectName(entity.getProjectName());
		processEntity.setFrontendUrl(frontendUrl);
		processService.saveOrUpdate(processEntity);
	}

	/**
	 * 根据单据id删除对应投标流程记录
	 *
	 * @param billId 单据id
	 */
	private void delProcess(Long billId) {
		LambdaQueryWrapper<ProcessEntity> l = new LambdaQueryWrapper<>();
		l.eq(ProcessEntity::getBillId, billId);
		processService.remove(l);
	}
}
