package com.ejianc.business.open.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.open.bean.OpenEntity;
import com.ejianc.business.open.mapper.OpenMapper;
import com.ejianc.business.open.service.IOpenService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * 开标记录实体
 *
 * @author generator
 */
@Service("openService")
public class OpenServiceImpl extends BaseServiceImpl<OpenMapper, OpenEntity> implements IOpenService {

	/**
	 * 只能有一个未生效的单据
	 *
	 * @param projectId 项目id
	 */
	@Override
	public void checkOnlyOne(Long projectId) {
		QueryWrapper<OpenEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		List<OpenEntity> entities = super.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(entities)) {
			throw new BusinessException("当前项目已存在未生效的单据！");
		}
	}

}
