package com.ejianc.business.plan.api;


import com.ejianc.business.plan.hystrix.BudgetPlanHystrix;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * 计划单的rpc服务
 */
@FeignClient(name = "ejc-probudget-web", url = "${common.env.feign-client-url}", path = "ejc-probudget-web", fallback = BudgetPlanHystrix.class)
public interface IBudgetPlanApi {


    @RequestMapping(value = "/api/budgetPlan/recal", method = RequestMethod.POST)
    CommonResponse<RecalculateVO> recal(@RequestBody RecalculateVO vo);

}
